package com.braintree.paypal.converters.impl;

import com.braintree.enums.BrainTreeCardType;
import com.braintree.hybris.data.BrainTreePaymentInfoData;
import com.braintree.model.BrainTreePaymentInfoModel;
import de.hybris.bootstrap.annotations.UnitTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

import static org.hamcrest.Matchers.instanceOf;
import static org.mockito.Mockito.when;

@UnitTest
public class BrainTreePaymentInfoDataConverterTest {
    @InjectMocks
    BrainTreePaymentInfoDataConverter brainTreePaymentInfoDataConverter;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void convertShouldConvertToBrainTreePaymentInfoData() {
        BrainTreePaymentInfoModel paymentInfo = Mockito.mock(BrainTreePaymentInfoModel.class);
        BrainTreePaymentInfoData paymentData = Mockito.mock(BrainTreePaymentInfoData.class);
        BrainTreeCardType brainTreeCardType = Mockito.mock(BrainTreeCardType.class);

        paymentInfo.setPaymentProvider("mockProvider");
        paymentInfo.setPaypalFundingSource("mockSource");
        paymentInfo.setCardNumber("mockNumber");
        paymentInfo.setPayer("mockPayer");
        paymentInfo.setExpirationMonth("mockMonth");
        paymentInfo.setExpirationYear("mockYear");
        paymentInfo.setImageSource("mockImageSource");
        paymentInfo.setCardholderName("mockName");
        paymentInfo.setCardType(brainTreeCardType);

        when(brainTreeCardType.getCode()).thenReturn("mockCode");

        Assert.assertThat(brainTreePaymentInfoDataConverter.convert(paymentInfo, paymentData), instanceOf(BrainTreePaymentInfoData.class));
    }
}
