package com.braintree.paypal.converters.impl;

import com.braintree.hybris.data.PayPalAddressData;
import com.braintree.paypal.validator.BraintreePayPalAddressDetailValidator;
import com.braintreegateway.Address;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.commercefacades.user.data.AddressData;
import de.hybris.platform.core.model.c2l.RegionModel;
import de.hybris.platform.core.model.user.AddressModel;
import de.hybris.platform.core.model.user.TitleModel;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

import static org.hamcrest.Matchers.instanceOf;
import static org.mockito.Mockito.when;

@UnitTest
public class BrainTreePayPalAddressDataConverterTest {

    @InjectMocks
    BrainTreePayPalAddressDataConverter brainTreePayPalAddressDataConverter;

    @Mock
    BraintreePayPalAddressDetailValidator payPalAddressDetailValidator;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void convertShouldConvertoToPayPalAddressData() {
        AddressModel hybrisAddress = Mockito.mock(AddressModel.class);
        PayPalAddressData paypalAddress = Mockito.mock(PayPalAddressData.class);
        TitleModel titleModel = Mockito.mock(TitleModel.class);
        RegionModel regionModel = Mockito.mock(RegionModel.class);

        titleModel.setName("mockTitleName");
        regionModel.setIsocodeShort("mockCode");

        when(hybrisAddress.getTitle()).thenReturn(titleModel);
        when(hybrisAddress.getRegion()).thenReturn(regionModel);

        Assert.assertThat(brainTreePayPalAddressDataConverter.convert(hybrisAddress, paypalAddress), instanceOf(PayPalAddressData.class));
    }

    @Test
    public void convertShouldReturnAddressData() {
        PayPalAddressData payPalAddressData = Mockito.mock(PayPalAddressData.class);

        when(payPalAddressData.getRecipientName()).thenReturn("mockName");
        when(payPalAddressData.getCountryCode()).thenReturn("mockCode");

        Assert.assertThat(brainTreePayPalAddressDataConverter.convert(payPalAddressData), instanceOf(AddressData.class));
    }

    @Test
    public void convertShouldReturnPayPalAddressData() {
        Address address = Mockito.mock(Address.class);
        String phone = "mockPhone";
        PayPalAddressData paypalAddress = Mockito.mock(PayPalAddressData.class);

        Assert.assertThat(brainTreePayPalAddressDataConverter.convert(address, phone, paypalAddress), instanceOf(PayPalAddressData.class));
    }
}
