package com.braintree.facade.impl;

import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.core.model.user.CustomerModel;
import de.hybris.platform.servicelayer.model.ModelService;
import de.hybris.platform.servicelayer.user.UserService;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;

import static org.junit.Assert.assertFalse;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;
import static org.mockito.Mockito.doNothing;
import static org.mockito.Mockito.verify;

@UnitTest
public class DefaultBrainTreeSetUpPasswordFacadeTest {

    private static final String ID = "id";
    private static final boolean IS_ACTIVE = true;
    private static final String PASSWORD_ENCODING = "pbkdf2";
    private static final String PASSWORD = "12341234";

    @Mock
    private UserService userService;
    @Mock
    private ModelService modelService;

    @Spy
    @InjectMocks
    private DefaultBrainTreeSetUpPasswordFacade unit;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void setPasswordForSingleAuthenticationActiveToCustomerTest() {
        final CustomerModel customer = mock(CustomerModel.class);

        when(userService.getUserForUID(ID)).thenReturn(customer);

        unit.setPasswordForSingleAuthenticationActiveToCustomer(ID, IS_ACTIVE);

        verify(customer).setPasswordForSingleAuthenticationActive(IS_ACTIVE);
        verify(modelService).save(customer);
    }

    @Test
    public void setUpPasswordTest() {
        final CustomerModel currentCustomer = mock(CustomerModel.class);

        when(userService.getCurrentUser()).thenReturn(currentCustomer);
        when(currentCustomer.getPasswordEncoding()).thenReturn(PASSWORD_ENCODING);
        doNothing().when(userService).setPassword(currentCustomer, PASSWORD, PASSWORD_ENCODING);
        doNothing().when(modelService).save(currentCustomer);

        unit.setUpPassword(PASSWORD);

        verify(userService).setPassword(currentCustomer, PASSWORD, PASSWORD_ENCODING);
        verify(currentCustomer).setPasswordForSingleAuthenticationActive(IS_ACTIVE);
        verify(modelService).save(currentCustomer);
    }

    @Test
    public void isSetUpPasswordFormTest() {
        final CustomerModel currentCustomer = mock(CustomerModel.class);

        when(userService.getCurrentUser()).thenReturn(currentCustomer);
        when(currentCustomer.isPasswordForSingleAuthenticationActive()).thenReturn(IS_ACTIVE);

        assertFalse(unit.isSetUpPasswordForm());
    }

    @Test
    public void isSetUpPasswordFormWithUserIdTest() {
        final CustomerModel currentCustomer = mock(CustomerModel.class);

        when(userService.getUserForUID(ID)).thenReturn(currentCustomer);
        when(currentCustomer.isPasswordForSingleAuthenticationActive()).thenReturn(IS_ACTIVE);

        assertFalse(unit.isSetUpPasswordForm(ID));
    }
}
