/**
 *
 */
package com.braintree.facade.backoffice.impl;

import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

import com.braintree.exceptions.BraintreeErrorException;
import com.braintree.order.refund.partial.services.BraintreePartialRefundService;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.core.model.order.OrderModel;
import de.hybris.platform.ordermanagementfacades.payment.data.PaymentTransactionEntryData;
import de.hybris.platform.payment.dto.TransactionStatus;
import de.hybris.platform.payment.enums.PaymentTransactionType;
import de.hybris.platform.payment.model.PaymentTransactionEntryModel;
import de.hybris.platform.payment.model.PaymentTransactionModel;
import de.hybris.platform.servicelayer.dto.converter.Converter;
import de.hybris.platform.servicelayer.model.ModelService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@UnitTest
public class DefaultBraintreeBackofficePartialRefundFacadeTest {

    private static final String SUCCESSFUL = "SUCCESFULL";
    private static final BigDecimal REFUND_AMOUNT = BigDecimal.TEN;

    @Mock
    private BraintreePartialRefundService partialRefundService;

    @Mock
    private Converter<PaymentTransactionEntryModel, PaymentTransactionEntryData> ordermanagementPaymentTransactionEntryConverter;

    @Mock
    private ModelService modelService;

    @InjectMocks
    private DefaultBraintreeBackofficePartialRefundFacade unit;


    @Before
    public void setUp() {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void isPartialRefundPossibleShouldReturnFalseIfOrderNull() {
        Assert.assertFalse(unit.isPartialRefundPossible(null));
    }

    @Test
    public void isPartialRefundPossibleShouldReturnTrueIfOrderHavePossibleRefundAmount() {
        OrderModel orderModel = Mockito.mock(OrderModel.class);
        PaymentTransactionModel transactionModel = Mockito.mock(PaymentTransactionModel.class);
        List<PaymentTransactionModel> paymentTransactionModels = new ArrayList<>();
        paymentTransactionModels.add(transactionModel);

        PaymentTransactionEntryModel entryModel = Mockito.mock(PaymentTransactionEntryModel.class);
        List<PaymentTransactionEntryModel> entryModels = new ArrayList<>();
        entryModels.add(entryModel);

        when(entryModel.getAmount()).thenReturn(BigDecimal.TEN);
        when(entryModel.getType()).thenReturn(PaymentTransactionType.CAPTURE);
        when(entryModel.getTransactionStatusDetails()).thenReturn(SUCCESSFUL);
        when(entryModel.getTransactionStatus()).thenReturn(TransactionStatus.ACCEPTED.name());
        when(transactionModel.getEntries()).thenReturn(entryModels);
        when(orderModel.getPaymentTransactions()).thenReturn(paymentTransactionModels);

        Assert.assertTrue(unit.isPartialRefundPossible(orderModel));
    }

    @Test
    public void partialRefundTransactionShouldCallPartialRefundService() throws BraintreeErrorException {
        OrderModel orderModel = Mockito.mock(OrderModel.class);
        PaymentTransactionEntryModel entryModel = Mockito.mock(PaymentTransactionEntryModel.class);

        unit.partialRefundTransaction(orderModel, entryModel, REFUND_AMOUNT);
        verify(partialRefundService).partialRefundTransaction(orderModel, entryModel, REFUND_AMOUNT);
    }
}
