/**
 *
 */
package com.braintree.converters.populators.impl;

import static org.mockito.Matchers.any;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

import com.braintree.model.BrainTreePaymentInfoModel;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.commercefacades.order.data.CCPaymentInfoData;
import de.hybris.platform.commercefacades.user.converters.populator.AddressReversePopulator;
import de.hybris.platform.commercefacades.user.data.AddressData;
import de.hybris.platform.core.model.user.AddressModel;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@UnitTest
public class BraintreePaymentInfoReversePopulatorTest {

    private static final String CARD_NUMBER = "cardNumber";
    private static final String ACCOUNT_HOLDER_NAME = "testName";
    private static final String CARD_HOLDER_NAME = "cardHolderName";
    private static final String SUBSCRIPTION_ID = "subscriptionID";
    private static final boolean IS_SAVED = true;
    private static final String PAYMENT_METHOD_TOKEN = "paymentMethodToken";
    private static final String PAYER = "payer";
    private static final String NONCE = "nonce";

    @Mock
    private AddressReversePopulator addressReversePopulator;

    @InjectMocks
    private BraintreePaymentInfoReversePopulator unit;


    @Before
    public void setUp() {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void populateShouldSetNeededFields() {
        final CCPaymentInfoData ccPaymentInfoData = Mockito.mock(CCPaymentInfoData.class);
        final BrainTreePaymentInfoModel brainTreePaymentInfoModel = new BrainTreePaymentInfoModel();
        final AddressData addressData = Mockito.mock(AddressData.class);
        final AddressModel addressModel = new AddressModel();

        brainTreePaymentInfoModel.setBillingAddress(addressModel);
        when(ccPaymentInfoData.getBillingAddress()).thenReturn(addressData);
        when(ccPaymentInfoData.getAccountHolderName()).thenReturn(ACCOUNT_HOLDER_NAME);
        when(ccPaymentInfoData.getCardholderName()).thenReturn(CARD_HOLDER_NAME);
        when(ccPaymentInfoData.getSubscriptionId()).thenReturn(SUBSCRIPTION_ID);
        when(ccPaymentInfoData.isSaved()).thenReturn(IS_SAVED);
        when(ccPaymentInfoData.getPaymentMethodToken()).thenReturn(PAYMENT_METHOD_TOKEN);
        when(ccPaymentInfoData.getPayer()).thenReturn(PAYER);
        when(ccPaymentInfoData.getPaymentMethodNonce()).thenReturn(NONCE);
        when(ccPaymentInfoData.getCardNumber()).thenReturn(CARD_NUMBER);

        unit.populate(ccPaymentInfoData, brainTreePaymentInfoModel);
        Assert.assertEquals(ACCOUNT_HOLDER_NAME, brainTreePaymentInfoModel.getImageSource());
        Assert.assertEquals(CARD_HOLDER_NAME, brainTreePaymentInfoModel.getCardholderName());
        Assert.assertEquals(SUBSCRIPTION_ID, brainTreePaymentInfoModel.getPaymentProvider());
        Assert.assertEquals(IS_SAVED, brainTreePaymentInfoModel.isSaved());
        Assert.assertEquals(PAYMENT_METHOD_TOKEN, brainTreePaymentInfoModel.getPaymentMethodToken());
        Assert.assertEquals(PAYER, brainTreePaymentInfoModel.getPayer());
        Assert.assertEquals(NONCE, brainTreePaymentInfoModel.getNonce());
        verify(addressReversePopulator).populate(addressData, addressModel);
    }
}
