/**
 *
 */
package com.braintree.converters.populators.impl;

import static org.mockito.Matchers.any;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

import com.braintree.model.BrainTreePaymentInfoModel;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.commercefacades.order.data.CCPaymentInfoData;
import de.hybris.platform.commercefacades.order.data.CartData;
import de.hybris.platform.core.model.order.CartModel;
import de.hybris.platform.servicelayer.dto.converter.Converter;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@UnitTest
public class BraintreeExtendedPaymentInfoPopulatorTest {

    @Mock
    private Converter<BrainTreePaymentInfoModel, CCPaymentInfoData> brainTreePaymentInfoConverter;

    @InjectMocks
    private BraintreeExtendedPaymentInfoPopulator unit;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void testPopulate() {
        final CartModel cartModel = Mockito.mock(CartModel.class);
        final CartData cartData = Mockito.mock(CartData.class);
        final BrainTreePaymentInfoModel infoModel = Mockito.mock(BrainTreePaymentInfoModel.class);

        when(cartModel.getPaymentInfo()).thenReturn(infoModel);
        unit.populate(cartModel, cartData);
        verify(cartData).setPaymentInfo(any());
        verify(brainTreePaymentInfoConverter).convert(infoModel);
    }
}
