/**
 *
 */
package com.braintree.converters.populators.impl;

import static org.mockito.Mockito.when;

import com.braintree.hybris.data.BraintreeLocalPaymentMethodData;
import com.braintree.model.BraintreeLocalPaymentMethodsModel;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.core.model.media.MediaModel;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

@UnitTest
public class BrainTreeLocalPaymentsPopulatorTest {


    private static final String CODE = "code";
    private static final String NAME = "name";
    private static final String URL = "url";
    private static final String ALT_TEXT = "altText";
    private static final boolean IS_ENABLED = true;
    private BrainTreeLocalPaymentsPopulator unit;

    @Before
    public void setUp() {
        unit = new BrainTreeLocalPaymentsPopulator();
    }

    @Test
    public void populateShouldSetNeededFields() {
        final BraintreeLocalPaymentMethodsModel paymentMethodsModel = Mockito.mock(BraintreeLocalPaymentMethodsModel.class);
        final BraintreeLocalPaymentMethodData paymentMethodData = new BraintreeLocalPaymentMethodData();
        final MediaModel mediaModel = Mockito.mock(MediaModel.class);

        when(mediaModel.getURL()).thenReturn(URL);
        when(mediaModel.getAltText()).thenReturn(ALT_TEXT);
        when(paymentMethodsModel.getCode()).thenReturn(CODE);
        when(paymentMethodsModel.getName()).thenReturn(NAME);
        when(paymentMethodsModel.getImage()).thenReturn(mediaModel);
        when(paymentMethodsModel.isIsEnabled()).thenReturn(IS_ENABLED);

        unit.populate(paymentMethodsModel, paymentMethodData);
        Assert.assertEquals(CODE, paymentMethodData.getCode());
        Assert.assertEquals(NAME, paymentMethodData.getName());
        Assert.assertEquals(IS_ENABLED, paymentMethodData.getIsEnabled());
        Assert.assertEquals(URL, paymentMethodData.getPathToImage());
        Assert.assertEquals(ALT_TEXT, paymentMethodData.getAltText());
    }
}
