/**
 *
 */
package com.braintree.converters.populators.impl;

import static org.mockito.Matchers.any;
import static org.mockito.Mockito.verify;

import com.braintree.hybris.data.BrainTreeSubscriptionInfoData;
import com.braintree.payment.dto.BraintreeInfo;
import de.hybris.bootstrap.annotations.UnitTest;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

@UnitTest
public class BrainTreeInfoPopulatorTest {

    private BrainTreeInfoPopulator unit;

    @Before
    public void setUp() {
        unit = new BrainTreeInfoPopulator();
    }

    @Test
    public void populateShouldSetAllNeededFields() {
        final BrainTreeSubscriptionInfoData subscriptionInfoData = Mockito.mock(BrainTreeSubscriptionInfoData.class);
        final BraintreeInfo braintreeInfo = Mockito.mock(BraintreeInfo.class);
        unit.populate(subscriptionInfoData, braintreeInfo);
        verify(braintreeInfo).setPaymentMethodToken(any());
        verify(braintreeInfo).setNonce(any());
        verify(braintreeInfo).setDeviceData(any());
        verify(braintreeInfo).setImageSource(any());
        verify(braintreeInfo).setExpirationMonth(any());
        verify(braintreeInfo).setExpirationYear(any());
        verify(braintreeInfo).setLiabilityShifted(any());
        verify(braintreeInfo).setCardNumber(any());
        verify(braintreeInfo).setCardType(any());
        verify(braintreeInfo).setEmail(any());
        verify(braintreeInfo).setCardholderName(any());
        verify(braintreeInfo).setIntent(any());
        verify(braintreeInfo).setAmount(any());
    }
}
