package com.braintree.user.converters.populator;

import de.hybris.platform.commercefacades.user.converters.populator.AddressPopulator;
import de.hybris.platform.commercefacades.user.data.AddressData;
import de.hybris.platform.core.model.user.AddressModel;
import org.apache.commons.lang.StringUtils;

import static com.braintree.constants.BraintreefacadesConstants.COMA_SEPARATOR;


public class BrainTreeAddressPopulator extends AddressPopulator {

    @Override
    public void populate(AddressModel source, AddressData target) {
        super.populate(source, target);
        if (StringUtils.isEmpty(source.getLastname())) {
            target.setLastName(COMA_SEPARATOR);
        }
        target.setBrainTreeAddressId(source.getBrainTreeAddressId());
    }
}
