/**
 *
 */
package com.braintree.paypal.converters.impl;

import com.braintree.hybris.data.BrainTreePaymentInfoData;
import com.braintree.model.BrainTreePaymentInfoModel;
import com.braintree.util.BrainTreeUtils;
import de.hybris.platform.servicelayer.dto.converter.ConversionException;
import de.hybris.platform.servicelayer.dto.converter.Converter;
import org.apache.commons.lang.StringUtils;


public class BrainTreePaymentInfoDataConverter implements
    Converter<BrainTreePaymentInfoModel, BrainTreePaymentInfoData> {

    @Override
    public BrainTreePaymentInfoData convert(final BrainTreePaymentInfoModel paymentInfo) throws ConversionException {
        final BrainTreePaymentInfoData paymentData = new BrainTreePaymentInfoData();
        return convert(paymentInfo, paymentData);
    }

    @Override
    public BrainTreePaymentInfoData convert(final BrainTreePaymentInfoModel paymentInfo,
        final BrainTreePaymentInfoData paymentData) throws ConversionException {
        paymentData.setPaymentType(paymentInfo.getPaymentProvider());
        paymentData.setPaypalFundingSource(paymentInfo.getPaypalFundingSource());
        paymentData.setCardNumber(paymentInfo.getCardNumber());
        paymentData.setEmail(paymentInfo.getPayer());
        paymentData.setExpirationMonth(paymentInfo.getExpirationMonth());
        paymentData.setExpirationYear(paymentInfo.getExpirationYear());
        paymentData.setImageSource(paymentInfo.getImageSource());
        if(StringUtils.isNotEmpty(paymentInfo.getCardholderName())) {
            paymentData.setCardholderName(paymentInfo.getCardholderName());
        }
        if (paymentInfo.getCardType() != null) {
            paymentData.setCardType(paymentInfo.getCardType().getCode());
        }
        if (paymentInfo.getLast4() != null) {
            paymentData.setLast4(paymentInfo.getLast4());
        }
        return paymentData;
    }

}
