/**
 *
 */
package com.braintree.facade.order.converters.populator;

import de.hybris.platform.commercefacades.order.converters.populator.OrderPopulator;
import de.hybris.platform.commercefacades.order.data.AbstractOrderData;
import de.hybris.platform.commercefacades.order.data.CCPaymentInfoData;
import de.hybris.platform.core.model.order.AbstractOrderModel;
import de.hybris.platform.core.model.order.payment.CreditCardPaymentInfoModel;
import de.hybris.platform.core.model.order.payment.PaymentInfoModel;
import de.hybris.platform.servicelayer.dto.converter.Converter;

import com.braintree.model.BrainTreePaymentInfoModel;


public class BrainTreeOrderPopulator extends OrderPopulator {

    private Converter<BrainTreePaymentInfoModel, CCPaymentInfoData> brainTreePaymentInfoConverter;

    @Override
    protected void addPaymentInformation(final AbstractOrderModel source, final AbstractOrderData prototype) {
        final PaymentInfoModel paymentInfo = source.getPaymentInfo();
        if (paymentInfo instanceof CreditCardPaymentInfoModel) {
            final CCPaymentInfoData paymentInfoData = getCreditCardPaymentInfoConverter()
                .convert((CreditCardPaymentInfoModel) paymentInfo);
            prototype.setPaymentInfo(paymentInfoData);
        } else if (paymentInfo instanceof BrainTreePaymentInfoModel) {
            final CCPaymentInfoData paymentInfoData = getBrainTreePaymentInfoConverter()
                .convert((BrainTreePaymentInfoModel) paymentInfo);
            prototype.setPaymentInfo(paymentInfoData);
        }
    }

    /**
     * @return the brainTreePaymentInfoConverter
     */
    public Converter<BrainTreePaymentInfoModel, CCPaymentInfoData> getBrainTreePaymentInfoConverter() {
        return brainTreePaymentInfoConverter;
    }

    /**
     * @param brainTreePaymentInfoConverter
     *           the brainTreePaymentInfoConverter to set
     */
    public void setBrainTreePaymentInfoConverter(
        final Converter<BrainTreePaymentInfoModel, CCPaymentInfoData> brainTreePaymentInfoConverter) {
        this.brainTreePaymentInfoConverter = brainTreePaymentInfoConverter;
    }


}
