package com.braintree.facade.impl;

import com.braintree.facade.BrainTreeSetUpPasswordFacade;
import de.hybris.platform.core.model.user.CustomerModel;
import de.hybris.platform.servicelayer.model.ModelService;
import de.hybris.platform.servicelayer.user.UserService;

public class DefaultBrainTreeSetUpPasswordFacade implements BrainTreeSetUpPasswordFacade {

    private UserService userService;
    private ModelService modelService;

    @Override
    public void setPasswordForSingleAuthenticationActiveToCustomer(String id, boolean isActive) {
        CustomerModel customer = (CustomerModel) userService.getUserForUID(id);
        customer.setPasswordForSingleAuthenticationActive(isActive);
        modelService.save(customer);
    }

    @Override
    public void setUpPassword(String password) {
        CustomerModel currentCustomer = (CustomerModel) userService.getCurrentUser();
        userService.setPassword(currentCustomer, password, currentCustomer.getPasswordEncoding());
        currentCustomer.setPasswordForSingleAuthenticationActive(true);
        modelService.save(currentCustomer);
    }

    @Override
    public boolean isSetUpPasswordForm()	{
        CustomerModel currentCustomer = (CustomerModel) userService.getCurrentUser();
        return !currentCustomer.isPasswordForSingleAuthenticationActive();
    }

    @Override
    public boolean isSetUpPasswordForm(String userId)	{
        CustomerModel currentCustomer = (CustomerModel) userService.getUserForUID(userId);
        return !currentCustomer.isPasswordForSingleAuthenticationActive();
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public void setModelService(ModelService modelService) {
        this.modelService = modelService;
    }
}
