package com.braintree.facade.backoffice;

import java.math.BigDecimal;
import java.util.List;
import java.util.function.Predicate;

import com.braintree.exceptions.BraintreeErrorException;

import de.hybris.platform.core.model.order.OrderModel;
import de.hybris.platform.ordermanagementfacades.payment.data.PaymentTransactionEntryData;
import de.hybris.platform.payment.model.PaymentTransactionEntryModel;

public interface BraintreeBackofficeMultiCaptureFacade {

    boolean isMultiCapturePossible(final OrderModel order);

    List<PaymentTransactionEntryModel> getMultiCaptureableTransactions(final OrderModel order);

    void executeMultiCapture(final PaymentTransactionEntryModel transactionId) throws BraintreeErrorException;

    PaymentTransactionEntryData partialCapture(OrderModel orderModel, BigDecimal captureAmount,
        String authorizeTransactionID) throws BraintreeErrorException;

    BigDecimal getPossibleAmountForCapture(OrderModel orderModel);

    boolean isPartialCapturePossible(OrderModel orderModel);

    BigDecimal getTransactionAmount(final PaymentTransactionEntryModel currentModel, final OrderModel orderModel);


    PaymentTransactionEntryData submitForSettlement(OrderModel orderModel, BigDecimal amount,
        String authorizeTransactionID)
        throws BraintreeErrorException;

    boolean isSubmitForSettlementAvailable(OrderModel orderModel);

    Predicate<PaymentTransactionEntryModel> getCaptureTransactionTypePredicate();

    Predicate<PaymentTransactionEntryModel> getAuthorizeTransactionTypePredicate();

    Predicate<PaymentTransactionEntryModel> getRefundTransactionTypePredicate();

    /**
     * Used to get authorization amount by transaction id
     * @param orderModel
     * @param transactionId
     * @return BigDecimal
     */
    BigDecimal getAuthorizationAmountByTransactionId(OrderModel orderModel, String transactionId);
}
