package com.braintree.facade;

import com.braintree.command.result.BrainTreeFindCustomerResult;
import com.braintree.form.UpdateCreditCardBillingAddressForm;
import com.braintree.hybris.data.BraintreeUserData;
import de.hybris.platform.commercefacades.order.data.CCPaymentInfoData;
import de.hybris.platform.commercefacades.user.UserFacade;
import de.hybris.platform.commercefacades.user.data.AddressData;

import java.util.List;

import com.braintree.hybris.data.BrainTreeSubscriptionInfoData;
import com.braintree.model.BrainTreePaymentInfoModel;
import de.hybris.platform.commercefacades.user.data.CustomerData;


/**
 * BrainTree User facade interface. Deals with methods related to user operations - registering, logging in and other.
 */
public interface BrainTreeUserFacade extends UserFacade {

    /**
     * remove the credit card info from the BrainTree by paymentMethodToken
     *
     * @param paymentMethodToken the paymentMethodToken
     */
    void removeBTCCPaymentInfo(String paymentMethodToken);

    /**
     * @param saved
     * @return
     */
    List<CCPaymentInfoData> getBrainTreeCCPaymentInfos(boolean saved);

    void editPaymentMethod(UpdateCreditCardBillingAddressForm updateCreditCardBillingAddressForm);

    BraintreeUserData getUserData();

    /**
     * This method finds customer by id
     * @param braintreeCustomerId customer id
     * @return BT customer result
     */
    BrainTreeFindCustomerResult findBrainTreeCustomer(String braintreeCustomerId);

    boolean isCurrentUserHasBrainTreeCustomerId();

    /**
     * Used to check is customer has not captured orders for saved payment method type
     * @param paymentProvider
     * @return boolean
     */
    boolean isCustomerHasNotCapturedOrdersForSavedPaymentMethodType(String paymentProvider);

    CustomerData getCustomerByPayerId(String payerId);

    boolean isPayerIdInCustomer(String uid);

    boolean isCustomerWithPayerIdExist(String payer_id);

    CustomerData getCustomerDataByUid(final String uId);

    AddressData getBillingAddressByPaymentMethodId(String paymentMethodId);
}
