package com.braintree.facade;

import com.braintree.hybris.data.BrainTreeConnectWithPayPalAddressData;
import com.braintree.hybris.data.BrainTreeConnectWithPayPalUserData;

public interface BrainTreeConnectWithPayPalFacade {

    BrainTreeConnectWithPayPalUserData getUserDataByAccessToken(String accessToken);

    String exchangeAuthorizationCodeToAccessToken(String authorizationToken);

    void setAccessTokenForCustomer(String accessTokenGuid, String payerId);

    void setDefaultAccessToken(String payerId);

    boolean isPayPalPaymentMethodPresentOrIntentOrder(String email);

    boolean shouldSavePayPalPaymentInfo();

    boolean isPayPalAddressPresent(String email, BrainTreeConnectWithPayPalAddressData addressData);

    boolean isPayPalPaymentMethodPresent(String email);

    void addAddressForNewUser(final BrainTreeConnectWithPayPalAddressData addressData, final String email);

}
