package com.braintree.converters.populators.impl;

import com.braintree.hybris.data.BraintreeLocalPaymentMethodData;
import com.braintree.model.BraintreeLocalPaymentMethodsModel;
import de.hybris.platform.converters.Populator;
import de.hybris.platform.servicelayer.dto.converter.ConversionException;

public class BrainTreeLocalPaymentsPopulator implements
    Populator<BraintreeLocalPaymentMethodsModel, BraintreeLocalPaymentMethodData> {

    @Override
    public void populate(BraintreeLocalPaymentMethodsModel source,
        BraintreeLocalPaymentMethodData target) throws ConversionException {
        target.setCode(source.getCode());
        target.setName(source.getName());
        target.setIsEnabled(source.isIsEnabled());
        target.setPathToImage(source.getImage().getURL());
        target.setAltText(source.getImage().getAltText());
    }
}
