package com.braintree.customersupportbackoffice.actions.order.refreshpaymentstatus;

import com.braintree.enums.BraintreePaymentTransactionStatus;
import com.braintree.facade.backoffice.BraintreeBackofficeRefreshPaymentStatusFacade;
import com.hybris.cockpitng.actions.ActionContext;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.core.model.order.OrderModel;
import de.hybris.platform.payment.model.PaymentTransactionModel;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;
import java.util.Arrays;

import static org.mockito.Mockito.*;

@UnitTest
@RunWith(MockitoJUnitRunner.class)
public class BraintreeRefreshPaymentStatusOrderActionTest {

    @Mock
    private BraintreeBackofficeRefreshPaymentStatusFacade refreshPaymentStatusFacade;

    @InjectMocks
    private BraintreeRefreshPaymentStatusOrderAction unit;

    @Test
    public void canPerformTest() {

        PaymentTransactionModel paymentTransactionModel = new PaymentTransactionModel();
        paymentTransactionModel.setBraintreePaymentTransactionStatus(BraintreePaymentTransactionStatus.AUTHORIZED);
        OrderModel orderModel = mock(OrderModel.class);
        ActionContext<OrderModel> actionContext = mock(ActionContext.class);
        when(orderModel.getPaymentTransactions()).thenReturn(Arrays.asList(paymentTransactionModel));
        when(actionContext.getData()).thenReturn(orderModel);
        boolean result = unit.canPerform(actionContext);
        Assert.assertTrue(result);

        paymentTransactionModel.setBraintreePaymentTransactionStatus(BraintreePaymentTransactionStatus.SETTLED);
        boolean result1 = unit.canPerform(actionContext);
        Assert.assertFalse(result1);
    }
}
