package com.braintree.paypal.converters.impl;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertNull;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;

import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.core.model.c2l.CountryModel;
import de.hybris.platform.core.model.c2l.RegionModel;
import de.hybris.platform.core.model.user.AddressModel;
import de.hybris.platform.core.model.user.CustomerModel;
import de.hybris.platform.payment.dto.BillingInfo;
import org.junit.Before;
import org.junit.Test;

@UnitTest
public class BraintreeBillingAddressConverterTest {

    private static final String FIRST_NAME = "FIRST_NAME";
    private static final String LAST_NAME = "LAST_NAME";
    private static final String STREET_NAME = "STREET_NAME";
    private static final String STREET_NUMBER = "STREET_NUMBER";
    private static final String TOWN = "CITY";
    private static final String POSTAL_CODE = "POSTAL_CODE";
    private static final String REGION_ICO_CODE = "REGION_ICO_CODE";
    private static final String COUNTRY_ISO_CODE = "COUNTRY_ISO_CODE";
    private static final String EMAIL = "EMAIL";

    private BraintreeBillingAddressConverter unit = new BraintreeBillingAddressConverter();

    AddressModel addressModel;
    RegionModel regionModel;
    CountryModel countryModel;

    @Before
    public void setUp() {
        addressModel = mock(AddressModel.class);
        regionModel = mock(RegionModel.class);
        countryModel = mock(CountryModel.class);

        when(addressModel.getFirstname()).thenReturn(FIRST_NAME);
        when(addressModel.getLastname()).thenReturn(LAST_NAME);
        when(addressModel.getStreetname()).thenReturn(STREET_NAME);
        when(addressModel.getStreetnumber()).thenReturn(STREET_NUMBER);
        when(addressModel.getTown()).thenReturn(TOWN);
        when(addressModel.getPostalcode()).thenReturn(POSTAL_CODE);
        when(addressModel.getRegion()).thenReturn(regionModel);
        when(addressModel.getCountry()).thenReturn(countryModel);
        when(regionModel.getIsocodeShort()).thenReturn(REGION_ICO_CODE);
        when(countryModel.getIsocode()).thenReturn(COUNTRY_ISO_CODE);
    }

    @Test
    public void convertShouldParseAddressAndGetEmailFromAddress() {
        when(addressModel.getEmail()).thenReturn(EMAIL);

        final BillingInfo billingInfo = unit.convert(addressModel);

        assertNotNull(billingInfo);
        assertEquals(FIRST_NAME, billingInfo.getFirstName());
        assertEquals(LAST_NAME, billingInfo.getLastName());
        assertEquals(STREET_NAME, billingInfo.getStreet1());
        assertEquals(STREET_NUMBER, billingInfo.getStreet2());
        assertEquals(TOWN, billingInfo.getCity());
        assertEquals(POSTAL_CODE, billingInfo.getPostalCode());
        assertEquals(REGION_ICO_CODE, billingInfo.getState());
        assertEquals(COUNTRY_ISO_CODE, billingInfo.getCountry());
        assertEquals(EMAIL, billingInfo.getEmail());
    }

    @Test
    public void convertShouldParseAddressAndGetEmailFromOwnerCustomer() {
        final CustomerModel customerModel = mock(CustomerModel.class);

        when(addressModel.getOwner()).thenReturn(customerModel);
        when(customerModel.getContactEmail()).thenReturn(EMAIL);

        final BillingInfo billingInfo = unit.convert(addressModel);

        assertNotNull(billingInfo);
        assertEquals(FIRST_NAME, billingInfo.getFirstName());
        assertEquals(LAST_NAME, billingInfo.getLastName());
        assertEquals(STREET_NAME, billingInfo.getStreet1());
        assertEquals(STREET_NUMBER, billingInfo.getStreet2());
        assertEquals(TOWN, billingInfo.getCity());
        assertEquals(POSTAL_CODE, billingInfo.getPostalCode());
        assertEquals(REGION_ICO_CODE, billingInfo.getState());
        assertEquals(COUNTRY_ISO_CODE, billingInfo.getCountry());
        assertEquals(EMAIL, billingInfo.getEmail());
    }

}
