/**
 *
 */
package com.braintree.order.capture.partial.process;

import static com.braintree.constants.BraintreeConstants.ORDER_PROCESS_NAME;
import static org.mockito.Matchers.any;
import static org.mockito.Mockito.never;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

import com.braintree.constants.BraintreeConstants;
import com.braintree.order.capture.partial.process.impl.DefaultBraintreeOrderCompleteProcessService;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.core.model.order.OrderModel;
import de.hybris.platform.orderprocessing.model.OrderProcessModel;
import de.hybris.platform.processengine.BusinessProcessService;
import de.hybris.platform.servicelayer.config.ConfigurationService;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@UnitTest
public class DefaultBraintreeBraintreeOrderCompleteProcessServiceTest {

    @Mock
    private BusinessProcessService businessProcessService;

    @Mock
    private ConfigurationService configurationService;

    @InjectMocks
    private DefaultBraintreeOrderCompleteProcessService unit;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks(this);

        Configuration configuration = Mockito.mock(Configuration.class);
        when(configurationService.getConfiguration()).thenReturn(configuration);
    }

    @Test
    public void testStartOrderCompletionProcessWithDefaultRestardNode() {
        OrderModel orderModel = Mockito.mock(OrderModel.class);
        OrderProcessModel orderProcessModel = Mockito.mock(OrderProcessModel.class);
        when(orderProcessModel.getProcessDefinitionName()).thenReturn(ORDER_PROCESS_NAME);
        List<OrderProcessModel> processModels = new ArrayList<>();
        processModels.add(orderProcessModel);
        when(orderModel.getOrderProcess()).thenReturn(processModels);

        unit.startOrderCompletionProcess(orderModel);
        verify(businessProcessService)
            .restartProcess(orderProcessModel, BraintreeConstants.DEFAULT_ORDER_PROCESS_RESTART_NODE);
    }

    @Test
    public void testStartOrderCompletionProcessWhenOrderNotHaveAnyOrderProcess() {
        OrderModel orderModel = Mockito.mock(OrderModel.class);
        unit.startOrderCompletionProcess(orderModel);
        verify(businessProcessService, never()).restartProcess(any(), any());
    }
}
