package com.braintree.job;

import com.braintree.model.BrainTreePaymentInfoModel;
import com.braintree.model.ValidateExpiredCartsCronJobModel;
import com.braintree.payment.info.service.BraintreePaymentInfoService;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.core.servicelayer.data.PaginationData;
import de.hybris.platform.core.servicelayer.data.SearchPageData;
import de.hybris.platform.cronjob.enums.CronJobResult;
import de.hybris.platform.cronjob.enums.CronJobStatus;
import de.hybris.platform.servicelayer.cronjob.PerformResult;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

import java.util.ArrayList;
import java.util.List;

import static org.mockito.Mockito.any;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

@UnitTest
public class ValidateExpiredCartsJobPerformableTest {

    @Mock
    private BraintreePaymentInfoService braintreePaymentInfoService;
    @InjectMocks
    private ValidateExpiredCartsJobPerformable unit;

    @Before
    public void init() {
        MockitoAnnotations.initMocks(this);

    }

    @Test
    public void performValidateExpiredCartsJobTest(){
        final ValidateExpiredCartsCronJobModel validateExpiredCartsCronJobModel = mock(ValidateExpiredCartsCronJobModel.class);
        final List<BrainTreePaymentInfoModel> paymentInfoModels = mock(ArrayList.class);
        final SearchPageData<BrainTreePaymentInfoModel> searchPageData = mock(SearchPageData.class);
        final PaginationData paginationData = mock(PaginationData.class);


        when(braintreePaymentInfoService.getAllSavedCreditCard(any(SearchPageData.class))).thenReturn(searchPageData);
        when(validateExpiredCartsCronJobModel.getPageSize()).thenReturn(100);
        when(searchPageData.getResults()).thenReturn(paymentInfoModels);
        when(searchPageData.getPagination()).thenReturn(paginationData);
        when(paginationData.getCurrentPage()).thenReturn(0);
        when(paginationData.getHasNext()).thenReturn(Boolean.FALSE);

        PerformResult performResult = unit.perform(validateExpiredCartsCronJobModel);

        Assert.assertEquals(CronJobStatus.FINISHED, performResult.getStatus());
        Assert.assertEquals(CronJobResult.SUCCESS, performResult.getResult());
        verify(braintreePaymentInfoService).updateAllExpiredStatuses(paymentInfoModels);
    }
}
