package com.braintree.job;

import com.braintree.enums.BraintreePaymentTransactionStatus;
import com.braintree.model.BraintreeUpdatePaymentTransactionStatusCronJobModel;
import com.braintree.transaction.service.BrainTreeTransactionService;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.core.servicelayer.data.PaginationData;
import de.hybris.platform.core.servicelayer.data.SearchPageData;
import de.hybris.platform.cronjob.enums.CronJobResult;
import de.hybris.platform.cronjob.enums.CronJobStatus;
import de.hybris.platform.payment.model.PaymentTransactionModel;
import de.hybris.platform.servicelayer.cronjob.PerformResult;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

import java.util.ArrayList;
import java.util.List;

import static org.mockito.Matchers.any;
import static org.mockito.Mockito.*;

@UnitTest
public class BraintreeUpdatePaymentTransactionStatusJobTest {

    @Mock
    private BrainTreeTransactionService brainTreeTransactionService;

    @InjectMocks
    private BraintreeUpdatePaymentTransactionStatusJob unit;

    @Before
    public void init() {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void performBraintreeUpdatePaymentTransactionStatusJobTest() {
        final BraintreeUpdatePaymentTransactionStatusCronJobModel cronJobModel = mock(BraintreeUpdatePaymentTransactionStatusCronJobModel.class);
        final List<PaymentTransactionModel> paymentTransactionModels = mock(ArrayList.class);
        final SearchPageData<PaymentTransactionModel> searchPageData = mock(SearchPageData.class);
        final PaginationData paginationData = mock(PaginationData.class);

        when(brainTreeTransactionService.getPaymentTransactionsByStatuses( any(ArrayList.class), any(SearchPageData.class))).thenReturn(searchPageData);
        when(cronJobModel.getPageSize()).thenReturn(100);
        when(searchPageData.getResults()).thenReturn(paymentTransactionModels);
        when(searchPageData.getPagination()).thenReturn(paginationData);
        when(paginationData.getCurrentPage()).thenReturn(0);
        when(paginationData.getHasNext()).thenReturn(Boolean.FALSE);

        PerformResult performResult = unit.perform(cronJobModel);

        Assert.assertEquals(CronJobStatus.FINISHED, performResult.getStatus());
        Assert.assertEquals(CronJobResult.SUCCESS, performResult.getResult());
        verify(brainTreeTransactionService).getPaymentTransactionsByStatuses(any(ArrayList.class), any(SearchPageData.class));
        verify(brainTreeTransactionService).updateBraintreePaymentTransactionStatuses(paymentTransactionModels);
    }
}
