package com.braintree.interceptors;

import com.braintree.command.result.BrainTreeFindCustomerResult;
import com.braintree.command.result.BrainTreePaymentDetailsResult;
import com.braintree.configuration.service.BrainTreeConfigService;
import com.braintree.method.impl.DefaultBrainTreePaymentService;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.core.model.user.CustomerModel;
import de.hybris.platform.servicelayer.interceptor.InterceptorContext;
import de.hybris.platform.servicelayer.interceptor.InterceptorException;
import junit.framework.TestCase;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

import java.util.List;

import static org.mockito.Matchers.any;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

@UnitTest
public class BrainTreeCustomerRemoveInterceptorTest extends TestCase {

    private static final String BRAIN_TREE_CUSTOMER_ID = "testCustomerId";

    private static final String PAYMENT_METHOD_TOKEN = "testToken";

    @Mock
    private DefaultBrainTreePaymentService brainTreePaymentService;

    @Mock
    private BrainTreeConfigService brainTreeConfigService;

    @InjectMocks
    private BrainTreeCustomerRemoveInterceptor unit;

    private CustomerModel customerModel;
    private InterceptorContext interceptorContext;
    private BrainTreeFindCustomerResult findCustomerResult;
    private BrainTreePaymentDetailsResult paymentDetailsResult;
    private List<BrainTreePaymentDetailsResult> paymentDetailsList;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);

        customerModel = Mockito.mock(CustomerModel.class);
        interceptorContext = Mockito.mock(InterceptorContext.class);
        findCustomerResult = Mockito.mock(BrainTreeFindCustomerResult.class);
        paymentDetailsResult = Mockito.mock(BrainTreePaymentDetailsResult.class);
        paymentDetailsList = List.of(paymentDetailsResult);

        when(customerModel.getBraintreeCustomerId()).thenReturn(BRAIN_TREE_CUSTOMER_ID);
    }

    @Test
    public void testDeleteCustomerWhenGraphQLEnable() throws InterceptorException {
        when(brainTreeConfigService.isBrainTreeGraphQLEnabled()).thenReturn(true);

        when(brainTreePaymentService.findCustomer(any())).thenReturn(findCustomerResult);
        when(findCustomerResult.getPaymentMethods()).thenReturn(paymentDetailsList);
        when(paymentDetailsResult.getPaymentMethodToken()).thenReturn(PAYMENT_METHOD_TOKEN);

        unit.onRemove(customerModel, interceptorContext);
        verify(brainTreePaymentService).deletePaymentMethod(any());
    }

    @Test
    public void testDeleteCustomerWhenGraphQLDisable() throws InterceptorException {
        when(brainTreeConfigService.isBrainTreeGraphQLEnabled()).thenReturn(false);

        unit.onRemove(customerModel, interceptorContext);
        verify(brainTreePaymentService).removeCustomer(any());
    }
}
