/**
 *
 */
package com.braintree.customfield.service.impl;

import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

import com.braintree.constants.BraintreeConstants.PropertyConfiguration;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.servicelayer.config.ConfigurationService;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@UnitTest
public class DefaultBraintreeBraintreeCustomFieldsServiceTest {

    public static final String KEY_1 = "key_1";
    public static final String KEY_2 = "key_2";

    private Configuration configuration;

    @Mock
    private ConfigurationService configurationService;

    @InjectMocks
    private DefaultBraintreeCustomFieldsService unit;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks(this);

        configuration = Mockito.mock(Configuration.class);
        List<String> list = new ArrayList<>();
        list.add(KEY_1);
        list.add(KEY_2);

        when(configuration.getKeys(PropertyConfiguration.BRAINTRE_CUSTOM_FIELD_GENERAL_KEY)).thenReturn(list.iterator());
        when(configurationService.getConfiguration()).thenReturn(configuration);
    }

    @Test
    public void name() {
        unit.getDefaultCustomFieldsMap();
        verify(configuration).getString(KEY_1);
        verify(configuration).getString(KEY_2);
    }

}
