/**
 *
 */
package com.braintree.cart.service.impl;

import static org.mockito.Mockito.verify;

import com.braintree.cart.dao.BrainTreeCartDAO;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

public class DefaultBrainTreeCartServiceTest {

    public static final String PAYMENT_ID = "paymentId";

    @Mock
    private BrainTreeCartDAO brainTreeCartDao;

    @InjectMocks
    private DefaultBrainTreeCartService unit;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void getCartForPaymentIdShouldCallDao() {
        unit.getCartForPaymentId(PAYMENT_ID);
        Assert.assertNotNull(unit.getBrainTreeCartDao());
        verify(brainTreeCartDao).getCartForPaymentId(PAYMENT_ID);
    }
}
