/**
 *
 */
package com.braintree.cart.dao.impl;

import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

import com.braintree.model.BrainTreePaymentInfoModel;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.core.model.order.CartModel;
import de.hybris.platform.servicelayer.search.FlexibleSearchQuery;
import de.hybris.platform.servicelayer.search.FlexibleSearchService;
import de.hybris.platform.servicelayer.search.SearchResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@UnitTest
public class DefaultBrainTreeCartDAOTest {

    protected static final String GET_CART_BY_PAYMENT_ID = "SELECT {cart:" + CartModel.PK + "} FROM {"
            + CartModel._TYPECODE + " as cart JOIN " + BrainTreePaymentInfoModel._TYPECODE +
            " as brainTreePaymentInfo" + " ON {cart:" + CartModel.PAYMENTINFO + "}={brainTreePaymentInfo:" +
            BrainTreePaymentInfoModel.PK + "}} " + "WHERE {brainTreePaymentInfo:" +
            BrainTreePaymentInfoModel.PAYMENTINFO + "} = ?paymentId";

    public static final String PAYMENT_ID = "paymentId";

    @Mock
    protected FlexibleSearchService flexibleSearchService;

    @InjectMocks
    private DefaultBrainTreeCartDAO unit;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void getCartForPaymentIdShouldReturnExceptedModel() {
        FlexibleSearchQuery fQuery;

        fQuery = new FlexibleSearchQuery(GET_CART_BY_PAYMENT_ID);
        fQuery.addQueryParameter(PAYMENT_ID, PAYMENT_ID);
        fQuery.setResultClassList(Collections.singletonList(CartModel.class));

        CartModel excepted = new CartModel();
        List<CartModel> list = new ArrayList<>();
        list.add(excepted);
        SearchResult<CartModel> searchResult = Mockito.mock(SearchResult.class);

        when(searchResult.getResult()).thenReturn(list);
        when(flexibleSearchService.<CartModel>search(fQuery)).thenReturn(searchResult);

        CartModel result = unit.getCartForPaymentId(PAYMENT_ID);
        Assert.assertEquals(excepted, result);
        verify(flexibleSearchService).search(fQuery);
    }

    @Test(expected = IllegalArgumentException.class)
    public void getCartForPaymentIdWithNullShouldThrowException() {
        unit.getCartForPaymentId(null);
    }
}
