package com.braintree.util;

import com.braintree.command.result.BrainTreePaymentDetailsResult;
import com.braintree.hybris.data.BrainTreeSubscriptionInfoData;
import com.braintree.model.BrainTreePaymentInfoModel;
import de.hybris.platform.core.model.c2l.RegionModel;
import de.hybris.platform.core.model.user.AddressModel;

public class BrainTreeDuplicateCheckUtils {

    private BrainTreeDuplicateCheckUtils() {
        throw new UnsupportedOperationException();
    }

    public static boolean emailBasedCheck(BrainTreePaymentDetailsResult oldPayment,
        BrainTreeSubscriptionInfoData newPayment) {
        return compareStrings(oldPayment.getEmail(), newPayment.getEmail());
    }

    public static boolean emailBasedCheck(BrainTreePaymentInfoModel newPayment, BrainTreePaymentInfoModel oldPayment) {
        return compareStrings(oldPayment.getPayer(), newPayment.getPayer());
    }

    public static boolean checkForGoogleAndSrc(BrainTreePaymentDetailsResult oldPayment,
        BrainTreeSubscriptionInfoData newPayment) {
        return compareStrings(oldPayment.getCardNumber(), newPayment.getCardNumber())
            && compareStrings(oldPayment.getExpirationMonth(), newPayment.getExpirationMonth())
            && compareStrings(oldPayment.getExpirationYear(), newPayment.getExpirationYear())
            && oldPayment.getCardType().equalsIgnoreCase(newPayment.getCardType())
            && compareStrings(oldPayment.getEmail(), newPayment.getEmail());
    }

    public static boolean checkForGoogleAndSrc(BrainTreePaymentInfoModel oldPayment, BrainTreePaymentInfoModel newPayment) {
        return compareStrings(oldPayment.getCardNumber(), newPayment.getCardNumber())
            && compareStrings(oldPayment.getExpirationMonth(), newPayment.getExpirationMonth())
            && compareStrings(oldPayment.getExpirationYear(), newPayment.getExpirationYear())
            && oldPayment.getCardType().getCode().equalsIgnoreCase(newPayment.getCardType().getCode())
            && compareStrings(oldPayment.getPayer(), newPayment.getPayer());
    }

    public static boolean checkRegion(String oldRegion, RegionModel newRegion) {
        if (oldRegion == null && newRegion == null){
            return true;
        }

        if(oldRegion == null || newRegion == null) {
            return false;
        }
        return oldRegion.equals(newRegion.getIsocodeShort());
    }

    public static boolean checkRegion(RegionModel oldRegion, RegionModel newRegion) {
        if (oldRegion == null && newRegion == null){
            return true;
        }

        if(oldRegion == null || newRegion == null) {
            return false;
        }
        return compareStrings(oldRegion.getIsocodeShort(), newRegion.getIsocodeShort());
    }

    private static boolean compareStrings(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        return s1 != null && s1.equals(s2);
    }

    public static boolean checkForCreditCard(BrainTreePaymentDetailsResult oldPayment,
        BrainTreeSubscriptionInfoData newPayment, AddressModel newBillingAddress) {

        return compareStrings(oldPayment.getCardNumber(), newPayment.getCardNumber())
            && compareStrings(oldPayment.getExpirationMonth(), newPayment.getExpirationMonth())
            && compareStrings(oldPayment.getExpirationYear(), newPayment.getExpirationYear())
            && oldPayment.getCardType().equalsIgnoreCase(newPayment.getCardType())
            && compareStrings(oldPayment.getCardholderName(), newPayment.getCardholder())
            && checkRegion(oldPayment.getBillingAddress().getRegion(), newBillingAddress.getRegion())
            && compareStrings(oldPayment.getBillingAddress().getFirstName(), newBillingAddress.getFirstname())
            && compareStrings(oldPayment.getBillingAddress().getLastName(), newBillingAddress.getLastname())
            && compareStrings(oldPayment.getBillingAddress().getPostalCode(), newBillingAddress.getPostalcode())
            && compareStrings(oldPayment.getBillingAddress().getStreetAddress(), newBillingAddress.getLine1())
            && compareStrings(oldPayment.getBillingAddress().getLocality(), newBillingAddress.getTown());
    }

    public static boolean checkForCreditCard(BrainTreePaymentInfoModel oldPayment, BrainTreePaymentInfoModel newPayment,
                                             AddressModel newBillingAddress) {
        return compareStrings(oldPayment.getCardNumber(), newPayment.getCardNumber())
            && compareStrings(oldPayment.getExpirationMonth(), newPayment.getExpirationMonth())
            && compareStrings(oldPayment.getExpirationYear(), newPayment.getExpirationYear())
            && oldPayment.getCardType().getCode().equalsIgnoreCase(newPayment.getCardType().getCode())
            && compareStrings(oldPayment.getCardholderName(), newPayment.getCardholderName())
            && compareStrings(oldPayment.getBillingAddress().getCountry().getIsocode(), newBillingAddress.getCountry().getIsocode())
            && checkRegion(oldPayment.getBillingAddress().getRegion(), newBillingAddress.getRegion())
            && compareStrings(oldPayment.getBillingAddress().getFirstname(), newBillingAddress.getFirstname())
            && compareStrings(oldPayment.getBillingAddress().getLastname(), newBillingAddress.getLastname())
            && compareStrings(oldPayment.getBillingAddress().getPostalcode(), newBillingAddress.getPostalcode())
            && compareStrings(oldPayment.getBillingAddress().getLine1(), newBillingAddress.getLine1())
            && compareStrings(oldPayment.getBillingAddress().getTown(), newBillingAddress.getTown());
    }

    public static boolean checkForUsBankAccount(BrainTreePaymentInfoModel oldPayment, BrainTreePaymentInfoModel newPayment) {
        return compareStrings(oldPayment.getLast4(), newPayment.getLast4())
                && compareStrings(oldPayment.getRoutingNumber(), newPayment.getRoutingNumber());
    }

    public static boolean checkForUsBankAccount(BrainTreePaymentDetailsResult oldPayment, BrainTreeSubscriptionInfoData newPayment) {
        return compareStrings(oldPayment.getLast4(), newPayment.getLast4())
                && compareStrings(oldPayment.getRoutingNumber(), newPayment.getRoutingNumber());
    }
}
