package com.braintree.service;

import com.braintree.hybris.data.BrainTreeConnectWithPayPalUserData;

/**
 * This interface is used to work with user data by access token
 */

public interface BrainTreeConnectWithPayPalService {
    /**
     * This method is used to exchange AuthorizationCode To Access Token
     * @param authorizationToken authorizationToken
     * @return exchanged AuthorizationCode
     */
    String exchangeAuthorizationCodeToAccessToken(String authorizationToken);

    /**
     * This method is used to get BrainTreeConnectWithPayPalUserData by accessToken
     * @param accessToken access token
     * @return BrainTreeConnectWithPayPalUserData
     */
    BrainTreeConnectWithPayPalUserData getUserDataByAccessToken(String accessToken);
}
