package com.braintree.populators;

import com.braintree.command.result.BrainTreeTransactionResult;
import com.braintreegateway.Transaction;
import de.hybris.platform.converters.Populator;
import de.hybris.platform.servicelayer.dto.converter.ConversionException;

public class TransactionToBraintreeTransactionResultPopulator implements Populator<Transaction, BrainTreeTransactionResult> {

    @Override
    public void populate(Transaction transaction, BrainTreeTransactionResult brainTreeTransactionResult)
            throws ConversionException {
        brainTreeTransactionResult.setStatus(transaction.getStatus().name());
        brainTreeTransactionResult.setTotalAmount(transaction.getAmount());
        brainTreeTransactionResult.setId(transaction.getId());
        brainTreeTransactionResult.setGraphQLId(transaction.getGraphQLId());
    }
}
