package com.braintree.populators;

import com.braintree.command.result.BrainTreeRefundTransactionResult;
import com.braintree.graphql.commands.request.BrainTreeExchangeLegacyIdRequest;
import com.braintree.graphql.commands.response.BrainTreeRefund;
import com.braintree.method.BrainTreePaymentService;
import de.hybris.platform.converters.Populator;
import de.hybris.platform.servicelayer.dto.converter.ConversionException;

import java.math.BigDecimal;

import static com.braintree.constants.BraintreeConstants.TYPE_TRANSACTION_PARAMETER;

public class BraintreeRefundToBrainTreeRefundTransactionResultPopulator implements
        Populator<BrainTreeRefund, BrainTreeRefundTransactionResult> {

    private BrainTreePaymentService brainTreePaymentService;

    @Override
    public void populate(BrainTreeRefund brainTreeRefund, BrainTreeRefundTransactionResult refundTransactionResult)
            throws ConversionException {
        refundTransactionResult.setTransactionId(brainTreeRefund.getId());
        String graphQLId = getGraphQLId(brainTreeRefund);
        refundTransactionResult.setTransactionGraphQLId(graphQLId);
        refundTransactionResult.setAmount(new BigDecimal(brainTreeRefund.getAmount().getValue()));
    }

    private String getGraphQLId(BrainTreeRefund brainTreeRefund) {
        BrainTreeExchangeLegacyIdRequest request = new BrainTreeExchangeLegacyIdRequest(brainTreeRefund.getLegacyId(),
                TYPE_TRANSACTION_PARAMETER);
        return brainTreePaymentService.exchangeLegacyIdToGraphQLId(request);
    }

    public void setBrainTreePaymentService(BrainTreePaymentService brainTreePaymentService) {
        this.brainTreePaymentService = brainTreePaymentService;
    }

}
