/**
 *
 */
package com.braintree.populators;

import com.braintree.command.result.BrainTreeBillingAddressResult;
import com.braintree.servicelayer.i18n.BraintreeRegionI18NService;
import de.hybris.platform.converters.Populator;
import de.hybris.platform.core.model.c2l.CountryModel;
import de.hybris.platform.core.model.user.AddressModel;
import de.hybris.platform.servicelayer.dto.converter.ConversionException;
import de.hybris.platform.servicelayer.i18n.CommonI18NService;

/**
 * Populates AddressModel from BrainTreeBillingAddressResult.
 */
public class BraintreeGraphQLAddressPopulator implements Populator<BrainTreeBillingAddressResult, AddressModel> {

    private CommonI18NService commonI18NService;
    private BraintreeRegionI18NService regionI18NService;

    @Override
    public void populate(BrainTreeBillingAddressResult address, AddressModel model) throws ConversionException {
        if (address != null && model != null) {
            final CountryModel country = findCountry(address.getCountyCode(), address.getCountyCodeAlpha3());
            model.setCountry(country);
            model.setZone(address.getRegion());
            model.setRegion(getRegionI18NService().findRegion(country, address.getRegion()));
            model.setStreetname(address.getStreetAddress());
            model.setStreetnumber(address.getExtendedAddress());
            model.setCompany(address.getCompany());
            model.setFirstname(address.getFirstName());
            model.setLastname(address.getLastName());
            model.setTown(address.getLocality());
            model.setPostalcode(address.getPostalCode());
        }
    }


    private CountryModel findCountry(final String countryCodeAlpha2, final String countryCodeAlpha3) {
        CountryModel country = getCommonI18NService().getCountry(countryCodeAlpha2);
        if (country == null && countryCodeAlpha3 != null) {
            country = getCommonI18NService().getCountry(countryCodeAlpha3);
        }
        return country;
    }


    public CommonI18NService getCommonI18NService() {
        return commonI18NService;
    }

    public void setCommonI18NService(CommonI18NService commonI18NService) {
        this.commonI18NService = commonI18NService;
    }

    public BraintreeRegionI18NService getRegionI18NService() {
        return regionI18NService;
    }

    public void setRegionI18NService(BraintreeRegionI18NService regionI18NService) {
        this.regionI18NService = regionI18NService;
    }

}
