package com.braintree.populators;

import com.braintree.command.result.BrainTreePaymentDetailsResult;
import com.braintreegateway.UsBankAccount;
import de.hybris.platform.converters.Populator;
import de.hybris.platform.servicelayer.dto.converter.ConversionException;
import org.apache.commons.lang.StringUtils;

import static com.braintree.constants.BraintreeConstants.US_BANK_ACCOUNT;

public class BrainTreeUsBankAccountPaymentMethodToPaymentDetailsPopulator implements
        Populator<UsBankAccount, BrainTreePaymentDetailsResult> {
    @Override
    public void populate(UsBankAccount usBankAccount, BrainTreePaymentDetailsResult target) throws ConversionException {
        target.setPaymentMethodToken(usBankAccount.getToken());
        target.setRoutingNumber(usBankAccount.getRoutingNumber());
        target.setVerified(usBankAccount.isVerified());
        target.setPaymentProvider(US_BANK_ACCOUNT);
        target.setLast4(usBankAccount.getLast4());
        target.setImageUrl(usBankAccount.getImageUrl());
        target.setCardType(StringUtils.EMPTY);
        target.setExpirationMonth(StringUtils.EMPTY);
        target.setExpirationYear(StringUtils.EMPTY);
        target.setCardNumber(StringUtils.EMPTY);
        target.setCardholderName(StringUtils.EMPTY);
    }
}
