/**
 *
 */
package com.braintree.populators;

import com.braintree.graphql.commands.request.BrainTreeAddressInput;
import de.hybris.platform.converters.Populator;
import de.hybris.platform.payment.dto.BillingInfo;
import de.hybris.platform.servicelayer.dto.converter.ConversionException;

/**
 * Populates BrainTreeAddressInput from BillingInfo.
 */
public class BrainTreeBillingInfoToGraphQLAddressInputPopulator implements
    Populator<BillingInfo, BrainTreeAddressInput> {

    @Override
    public void populate(BillingInfo billingAddress, BrainTreeAddressInput addressInput)
        throws ConversionException {
        addressInput.setCountryCode(billingAddress.getCountry());
        if (billingAddress.getState() != null) {
            addressInput.setRegion(billingAddress.getState());
        } else {
            addressInput.setRegion(billingAddress.getRegion());
        }
        addressInput.setFirstName(billingAddress.getFirstName());
        addressInput.setLastName(billingAddress.getLastName());
        addressInput.setStreetAddress(billingAddress.getStreet1());
        addressInput.setExtendedAddress(billingAddress.getStreet2());
        addressInput.setLocality(billingAddress.getCity());
        addressInput.setPostalCode(billingAddress.getPostalCode());
    }
}
