package com.braintree.payment.vault.impl;

import com.braintree.configuration.service.BrainTreeConfigService;
import com.braintree.payment.vault.StoreInVaultSupplier;
import com.braintree.util.BrainTreeUtils;

public class DefaultPayPalStoreInVaultSupplier implements StoreInVaultSupplier {

    private BrainTreeConfigService brainTreeConfigService;

    @Override
    public boolean isStore() {
        final boolean isIntentOrder = BrainTreeUtils.isIntentOrder(brainTreeConfigService.getIntent());

        // When credit or change payment button enabled will be used checkout with billing flow
        // so payment method could be save only during transaction creation
        return !isIntentOrder && (brainTreeConfigService.isStoreInVault() && !brainTreeConfigService.isCreditEnabled()
            && !brainTreeConfigService.isChangePaymentMethodButtonEnabled());
    }

    public BrainTreeConfigService getBrainTreeConfigService() {
        return brainTreeConfigService;
    }

    public void setBrainTreeConfigService(BrainTreeConfigService brainTreeConfigService) {
        this.brainTreeConfigService = brainTreeConfigService;
    }
}
