package com.braintree.payment.info.service;

import com.braintree.graphql.commands.response.BrainTreePaymentMethodSnapshot;
import com.braintree.model.BrainTreePaymentInfoModel;
import de.hybris.platform.commercefacades.user.data.AddressData;
import de.hybris.platform.core.model.user.AddressModel;
import de.hybris.platform.core.model.user.CustomerModel;
import de.hybris.platform.core.servicelayer.data.SearchPageData;

import java.util.List;
import java.util.Optional;


public interface BraintreePaymentInfoService {

    /**
     * find paymentInfo by customerId and code
     */
    Optional<BrainTreePaymentInfoModel> findByCustomerIdAndCode(String customerId, String code);

    /**
     * remove paymentInfo by customerId and paymentMethodToken
     */
    void remove(String customerId, String paymentMethodToken);

    /**
     * disable paymentInfo by customerId and paymentMethodToken
     */
    void disable(String customerId, String paymentMethodToken);

    /**
     * add paymentInfo to customer
     */
    void addToCustomer(BrainTreePaymentInfoModel paymentInfo);

    /**
     * update customer paymentInfo
     */
    void update(String paymentMethodToken, BrainTreePaymentInfoModel paymentInfo);

    /**
     * update customer paymentInfo and address
     */
    void update(BrainTreePaymentInfoModel braintreePaymentInfo, AddressData addressData);

    /**
     * Used to find customer paymentInfo and address
     * @param legacyToken
     * @return String
     */
    String getGraphQLTokenForPaymentMethod(String legacyToken);

    /**
     * Used to get payment provider by details and origin
     * @param detailsType
     * @param originType
     * @return String
     */
    String getPaymentProviderByDetailsAndOrigin(String detailsType, String originType);

    /**
     * Used to get image source by payment provider and card type
     * @param paymentProvider
     * @param cardType
     * @return String
     */
    String getImageSourceByPaymentProviderAndCardType(String paymentProvider, String cardType);

    /**
     * Used to get payment instrument type by snapshot and origin
     * @param paymentMethodSnapshot
     * @return String
     */
    String getPaymentInstrumentTypeBySnapshotAndOrigin(BrainTreePaymentMethodSnapshot paymentMethodSnapshot);

    /**
     * Used to update Expired Status for payment info
     * @param paymentInfoModel
     */
    void updateExpiredStatus(BrainTreePaymentInfoModel paymentInfoModel);

    /**
     * Used to update Expired Status for list of payments info
     * @param paymentInfoModels
     */
    void updateAllExpiredStatuses(List<BrainTreePaymentInfoModel> paymentInfoModels);

    /**
     * Used to get duplicate payment method
     * @param paymentInfo
     * @param customer
     * @param billingAddress
     */
    void checkOnDuplicatePaymentMethod(BrainTreePaymentInfoModel paymentInfo, CustomerModel customer, AddressModel billingAddress);

    /**
     * Used to get all saved payments info with payment provider - CreditCard
     * @param searchPageData
     * @return searchPageData
     */
    SearchPageData<BrainTreePaymentInfoModel> getAllSavedCreditCard(SearchPageData<BrainTreePaymentInfoModel> searchPageData);

    /**
     * Used to get all saved payments info by customer with payment provider - CreditCard
     * @param customerId
     * @return List<BrainTreePaymentInfoModel>
     */
    List<BrainTreePaymentInfoModel> getAllSavedCreditCardByCustomer(String customerId);
}
