package com.braintree.payment.info.dao;

import com.braintree.model.BrainTreePaymentInfoModel;
import de.hybris.platform.core.servicelayer.data.SearchPageData;

import java.util.List;
import java.util.Optional;


public interface BrainTreePaymentInfoDao {

    /**
     * find paymentInfo by customerId and paymentMethodToken
     */
    BrainTreePaymentInfoModel find(String customerId, String paymentMethodToken);

    /**
     * find paymentInfo by customerId and code
     */
    Optional<BrainTreePaymentInfoModel> findByCustomerIdAndCode(String customerId, String code);

    /**
     * find paymentInfo by paymentMethodToken
     */
    BrainTreePaymentInfoModel find(String paymentMethodToken);

    /**
     * find paymentInfo with payment provider = CreditCard, isSaved = true and ExpiredStatus != expired
     * */
    SearchPageData<BrainTreePaymentInfoModel> findAllSavedCreditCard(
            SearchPageData<BrainTreePaymentInfoModel> searchPageData);

    /**
     * find paymentInfo by customer with payment provider = CreditCard
     * */
    List<BrainTreePaymentInfoModel> findAllSavedCreditCardByCustomer(String customerId);
}
