package com.braintree.order.strategy.impl;

import com.braintree.order.strategy.BraintreeOrderCodeIdentificationStrategy;
import org.springframework.beans.factory.annotation.Required;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import static de.hybris.platform.servicelayer.util.ServicesUtil.validateParameterNotNull;

public class DefaultBraintreeOrderCodeIdentificationStrategy implements BraintreeOrderCodeIdentificationStrategy {

    private String idPattern;

    @Override
    public boolean isID(final String potentialId) {
        validateParameterNotNull(potentialId, "identifier must not be null");
        if (potentialId == null || potentialId.isEmpty()) {
            return false;
        }

        final Pattern pattern = Pattern.compile(this.idPattern);
        final Matcher matcher = pattern.matcher(potentialId);
        return matcher.find();
    }

    @Required
    public void setIdPattern(final String idPattern) {
        this.idPattern = idPattern;
    }
}
