package com.braintree.interceptors;

import com.braintree.command.request.BrainTreeCustomerRequest;
import com.braintree.command.request.BrainTreeDeletePaymentMethodRequest;
import com.braintree.command.result.BrainTreeFindCustomerResult;
import com.braintree.command.result.BrainTreePaymentDetailsResult;
import com.braintree.configuration.service.BrainTreeConfigService;
import com.braintree.method.impl.DefaultBrainTreePaymentService;
import org.apache.commons.lang.StringUtils;
import de.hybris.platform.core.model.user.CustomerModel;
import de.hybris.platform.servicelayer.interceptor.InterceptorContext;
import de.hybris.platform.servicelayer.interceptor.InterceptorException;
import de.hybris.platform.servicelayer.interceptor.RemoveInterceptor;

public class BrainTreeCustomerRemoveInterceptor implements RemoveInterceptor<CustomerModel> {

    private DefaultBrainTreePaymentService brainTreePaymentService;

    private BrainTreeConfigService brainTreeConfigService;

    @Override
    public void onRemove(CustomerModel customerModel, InterceptorContext interceptorContext) throws InterceptorException {
        String brainTreeCustomerId = customerModel.getBraintreeCustomerId();
        if (StringUtils.isNotBlank(brainTreeCustomerId)) {
            final BrainTreeCustomerRequest customerRequest = new BrainTreeCustomerRequest(brainTreeCustomerId);
            customerRequest.setCustomerId(brainTreeCustomerId);
            if (brainTreeConfigService.isBrainTreeGraphQLEnabled()) {
                final BrainTreeFindCustomerResult findCustomerResult = brainTreePaymentService.findCustomer(customerRequest);
                findCustomerResult.getPaymentMethods()
                        .stream()
                        .map(BrainTreePaymentDetailsResult::getPaymentMethodToken)
                        .forEach(token -> brainTreePaymentService.deletePaymentMethod(new BrainTreeDeletePaymentMethodRequest(brainTreeCustomerId, token)));
            }
            brainTreePaymentService.removeCustomer(customerRequest);
        }
    }

    public void setBrainTreePaymentService(DefaultBrainTreePaymentService brainTreePaymentService) {
        this.brainTreePaymentService = brainTreePaymentService;
    }

    public void setBrainTreeConfigService(BrainTreeConfigService brainTreeConfigService) {
        this.brainTreeConfigService = brainTreeConfigService;
    }
}
