package com.braintree.helpers;

import com.braintree.configuration.service.BrainTreeConfigService;
import com.braintree.util.BrainTreeUtils;

public class SubmitForSettlementHelper {

    private BrainTreeConfigService brainTreeConfigService;

    public boolean isAvailableSubmitForSettlement(String paymentType) {
        return isAvailableSubmitForSettlementByIntent(paymentType)
                || isAvailableSubmitForSettlementBySettlementConfigParameter(paymentType)
                || BrainTreeUtils.isUsBankAccountPayment(paymentType);
    }

    public boolean isAvailableSubmitForSettlementByIntent(String paymentType) {
        return (BrainTreeUtils.isPayPalPayment(paymentType) || BrainTreeUtils.isLPMPayment(paymentType))
                && BrainTreeUtils.isIntentSale(brainTreeConfigService.getIntent());
    }

    public boolean isAvailableSubmitForSettlementBySettlementConfigParameter(String paymentType) {
        return !(BrainTreeUtils.isPayPalPayment(paymentType) || BrainTreeUtils.isLPMPayment(paymentType))
                && brainTreeConfigService.isSubmitForSettlement();
    }

    public void setBrainTreeConfigService(BrainTreeConfigService brainTreeConfigService) {
        this.brainTreeConfigService = brainTreeConfigService;
    }

}
