/**
 *
 */
package com.braintree.graphql.commands.response;

import java.util.Calendar;
import java.util.List;

/**
 * This class is a representation of Transaction and is used in GraphQL API.
 */
public class BrainTreeTransaction {

    private String id;
    private String legacyId;
    private String merchantAccountId;
    private String orderId;
    private BrainTreeMonetaryAmount amount;
    private Calendar createdAt;
    private BrainTreePaymentStatus status;
    private BrainTreeRiskData riskData;
    private BrainTreeCustomer customer;
    private BrainTreePaymentMethodSnapshot paymentMethodSnapshot;
    private BrainTreePaymentMethod paymentMethod;
    private List<BrainTreeRefund> refunds;
    private List<BrainTreePaymentStatusEvent> statusHistory;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getLegacyId() {
        return legacyId;
    }

    public void setLegacyId(String legacyId) {
        this.legacyId = legacyId;
    }

    public BrainTreePaymentStatus getStatus() {
        return status;
    }

    public void setStatus(BrainTreePaymentStatus status) {
        this.status = status;
    }

    public String getMerchantAccountId() {
        return merchantAccountId;
    }

    public void setMerchantAccountId(String merchantAccountId) {
        this.merchantAccountId = merchantAccountId;
    }

    public String getOrderId() {
        return orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public BrainTreeMonetaryAmount getAmount() {
        return amount;
    }

    public void setAmount(BrainTreeMonetaryAmount amount) {
        this.amount = amount;
    }

    public Calendar getCreatedAt() {
        return createdAt;
    }

    public void setCreatedAt(Calendar createdAt) {
        this.createdAt = createdAt;
    }

    public BrainTreePaymentMethodSnapshot getPaymentMethodSnapshot() {
        return paymentMethodSnapshot;
    }

    public void setPaymentMethodSnapshot(
        BrainTreePaymentMethodSnapshot paymentMethodSnapshot) {
        this.paymentMethodSnapshot = paymentMethodSnapshot;
    }

    public BrainTreePaymentMethod getPaymentMethod() {
        return paymentMethod;
    }

    public void setPaymentMethod(BrainTreePaymentMethod paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public List<BrainTreePaymentStatusEvent> getStatusHistory() {
        return statusHistory;
    }

    public void setStatusHistory(
        List<BrainTreePaymentStatusEvent> statusHistory) {
        this.statusHistory = statusHistory;
    }

    public BrainTreePaymentStatusEvent findFirstEventByType(String typename) {
        for (final BrainTreePaymentStatusEvent event : statusHistory) {
            if (event.get__typename().equalsIgnoreCase(typename)) {
                return event;
            }
        }
        return null;
    }


    public BrainTreeCustomer getCustomer() {
        return customer;
    }

    public void setCustomer(BrainTreeCustomer customer) {
        this.customer = customer;
    }

    public BrainTreeRiskData getRiskData() {
        return riskData;
    }

    public void setRiskData(BrainTreeRiskData riskData) {
        this.riskData = riskData;
    }

    public List<BrainTreeRefund> getRefunds() {
        return refunds;
    }

    public void setRefunds(List<BrainTreeRefund> refunds) {
        this.refunds = refunds;
    }
}
