/**
 *
 */
package com.braintree.graphql.commands.request;

import java.util.Objects;

/**
 * This class is a representation of TransactionShippingInput and is used in GraphQL API.
 */
public class BrainTreeTransactionShippingInput {

    private BrainTreeAddressInput shippingAddress;
    private String shippingAmount;
    private String shipsFromPostalCode;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        final BrainTreeTransactionShippingInput that = (BrainTreeTransactionShippingInput) o;
        return Objects.equals(shippingAddress, that.shippingAddress) &&
            Objects.equals(shippingAmount, that.shippingAmount) &&
            Objects.equals(shipsFromPostalCode, that.shipsFromPostalCode);
    }

    @Override
    public int hashCode() {
        return Objects.hash(shippingAddress, shippingAmount, shipsFromPostalCode);
    }

    public BrainTreeAddressInput getShippingAddress() {
        return shippingAddress;
    }

    public void setShippingAddress(BrainTreeAddressInput shippingAddress) {
        this.shippingAddress = shippingAddress;
    }

    public String getShippingAmount() {
        return shippingAmount;
    }

    public void setShippingAmount(String shippingAmount) {
        this.shippingAmount = shippingAmount;
    }

    public String getShipsFromPostalCode() {
        return shipsFromPostalCode;
    }

    public void setShipsFromPostalCode(String shipsFromPostalCode) {
        this.shipsFromPostalCode = shipsFromPostalCode;
    }
}
