/**
 *
 */
package com.braintree.graphql.commands.request;

import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;

/**
 * This class is a representation of TransactionInput and is used in GraphQL API.
 */
public class BrainTreeTransactionInput {

    private BigDecimal amount;
    private String merchantAccountId;
    private String customerId;
    private BrainTreeVaultPaymentMethodAfterTransactingInput vaultPaymentMethodAfterTransacting;
    private BrainTreeRiskDataInput riskData;
    private BrainTreeTransactionDescriptorInput descriptor;
    private BrainTreeTransactionShippingInput shipping;
    private String channel;
    private List<BrainTreeCustomFieldInput> customFields;
    private BrainTreeTransactionTaxInput tax;
    private String discountAmount;
    private List<BrainTreeTransactionLineItemInput> lineItems;
    private BrainTreeTransactionCustomerDetailsInput customerDetails;
    private String orderId;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        final BrainTreeTransactionInput that = (BrainTreeTransactionInput) o;
        return Objects.equals(amount, that.amount) &&
            Objects.equals(merchantAccountId, that.merchantAccountId) &&
            Objects.equals(customerId, that.customerId) &&
            Objects.equals(vaultPaymentMethodAfterTransacting, that.vaultPaymentMethodAfterTransacting) &&
            Objects.equals(riskData, that.riskData) &&
            Objects.equals(descriptor, that.descriptor) &&
            Objects.equals(shipping, that.shipping) &&
            Objects.equals(channel, that.channel) &&
            Objects.equals(customFields, that.customFields) &&
            Objects.equals(tax, that.tax) &&
            Objects.equals(discountAmount, that.discountAmount) &&
            Objects.equals(lineItems, that.lineItems) &&
            Objects.equals(customerDetails, that.customerDetails);
    }

    @Override
    public int hashCode() {
        return Objects
            .hash(amount, merchantAccountId, customerId, vaultPaymentMethodAfterTransacting, riskData, descriptor, shipping, channel,
                customFields, tax, discountAmount, lineItems, customerDetails);
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public String getMerchantAccountId() {
        return merchantAccountId;
    }

    public void setMerchantAccountId(String merchantAccountId) {
        this.merchantAccountId = merchantAccountId;
    }

    public String getCustomerId() {
        return customerId;
    }

    public void setCustomerId(String customerId) {
        this.customerId = customerId;
    }

    public BrainTreeVaultPaymentMethodAfterTransactingInput getVaultPaymentMethodAfterTransacting() {
        return vaultPaymentMethodAfterTransacting;
    }

    public void setVaultPaymentMethodAfterTransacting(
        BrainTreeVaultPaymentMethodAfterTransactingInput vaultPaymentMethodAfterTransacting) {
        this.vaultPaymentMethodAfterTransacting = vaultPaymentMethodAfterTransacting;
    }

    public BrainTreeRiskDataInput getRiskData() {
        return riskData;
    }

    public void setRiskData(BrainTreeRiskDataInput riskData) {
        this.riskData = riskData;
    }

    public BrainTreeTransactionDescriptorInput getDescriptor() {
        return descriptor;
    }

    public void setDescriptor(BrainTreeTransactionDescriptorInput descriptor) {
        this.descriptor = descriptor;
    }

    public BrainTreeTransactionShippingInput getShipping() {
        return shipping;
    }

    public void setShipping(BrainTreeTransactionShippingInput shipping) {
        this.shipping = shipping;
    }

    public String getChannel() {
        return channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public List<BrainTreeCustomFieldInput> getCustomFields() {
        return customFields;
    }

    public void setCustomFields(List<BrainTreeCustomFieldInput> customFields) {
        this.customFields = customFields;
    }

    public BrainTreeTransactionTaxInput getTax() {
        return tax;
    }

    public void setTax(BrainTreeTransactionTaxInput tax) {
        this.tax = tax;
    }

    public String getDiscountAmount() {
        return discountAmount;
    }

    public void setDiscountAmount(String discountAmount) {
        this.discountAmount = discountAmount;
    }

    public List<BrainTreeTransactionLineItemInput> getLineItems() {
        return lineItems;
    }

    public void setLineItems(List<BrainTreeTransactionLineItemInput> lineItems) {
        this.lineItems = lineItems;
    }

    public BrainTreeTransactionCustomerDetailsInput getCustomerDetails() {
        return customerDetails;
    }

    public void setCustomerDetails(
        BrainTreeTransactionCustomerDetailsInput customerDetails) {
        this.customerDetails = customerDetails;
    }

    public String getOrderId() {
        return orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }
}
