/**
 *
 */
package com.braintree.graphql.commands.request;

import java.util.Objects;

/**
 * This class is a representation of RiskDataInput and is used in GraphQL API.
 */
public class BrainTreeRiskDataInput {

    private String deviceData;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        final BrainTreeRiskDataInput that = (BrainTreeRiskDataInput) o;
        return Objects.equals(deviceData, that.deviceData);
    }

    @Override
    public int hashCode() {
        return Objects.hash(deviceData);
    }

    public String getDeviceData() {
        return deviceData;
    }

    public void setDeviceData(String deviceData) {
        this.deviceData = deviceData;
    }
}
