/**
 *
 */
package com.braintree.graphql.commands.request;

import java.util.Objects;

/**
 * This class is a representation of AddressInput and is used in GraphQL API.
 */
public class BrainTreeAddressInput {

    private String company;
    private String streetAddress;
    private String addressLine1;
    private String extendedAddress;
    private String addressLine2;
    private String firstName;
    private String lastName;
    private String locality;
    private String region;
    private String postalCode;
    private String countryCode;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        final BrainTreeAddressInput that = (BrainTreeAddressInput) o;
        return Objects.equals(company, that.company) &&
            Objects.equals(streetAddress, that.streetAddress) &&
            Objects.equals(addressLine1, that.addressLine1) &&
            Objects.equals(extendedAddress, that.extendedAddress) &&
            Objects.equals(addressLine2, that.addressLine2) &&
            Objects.equals(firstName, that.firstName) &&
            Objects.equals(lastName, that.lastName) &&
            Objects.equals(locality, that.locality) &&
            Objects.equals(region, that.region) &&
            Objects.equals(postalCode, that.postalCode) &&
            Objects.equals(countryCode, that.countryCode);
    }

    @Override
    public int hashCode() {
        return Objects
            .hash(company, streetAddress, addressLine1, extendedAddress, addressLine2, firstName, lastName, locality, region, postalCode,
                countryCode);
    }

    public String getCompany() {
        return company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public String getStreetAddress() {
        return streetAddress;
    }

    public void setStreetAddress(String streetAddress) {
        this.streetAddress = streetAddress;
    }

    public String getAddressLine1() {
        return addressLine1;
    }

    public void setAddressLine1(String addressLine1) {
        this.addressLine1 = addressLine1;
    }

    public String getExtendedAddress() {
        return extendedAddress;
    }

    public void setExtendedAddress(String extendedAddress) {
        this.extendedAddress = extendedAddress;
    }

    public String getAddressLine2() {
        return addressLine2;
    }

    public void setAddressLine2(String addressLine2) {
        this.addressLine2 = addressLine2;
    }

    public String getFirstName() {
        return firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getLocality() {
        return locality;
    }

    public void setLocality(String locality) {
        this.locality = locality;
    }

    public String getRegion() {
        return region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getPostalCode() {
        return postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public String getCountryCode() {
        return countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }
}
