/**
 *
 */
package com.braintree.graphql.commands.impl;

import static com.braintree.constants.BraintreeConstants.ID_FROM_LEGACY_PARAMETER;
import static com.braintree.constants.BraintreeConstants.LEGACY_ID_PARAMETER;
import static com.braintree.constants.BraintreeConstants.RESULT_DATA;
import static com.braintree.constants.BraintreeConstants.RESULT_ERRORS;
import static com.braintree.constants.BraintreeConstants.TYPE_PARAMETER;

import com.braintree.commands.impl.AbstractCommand;
import com.braintree.graphql.commands.BrainTreeGraphQLExchangeLegacyIdCommand;
import com.braintree.graphql.commands.request.BrainTreeExchangeLegacyIdRequest;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

/**
 * This class extends AbstractCommand, implements BrainTreeGraphQLExchangeLegacyIdCommand and is used in GraphQL API.
 */
public class DefaultBrainTreeGraphQLExchangeLegacyIdCommand extends
    AbstractCommand<BrainTreeExchangeLegacyIdRequest, String>
    implements BrainTreeGraphQLExchangeLegacyIdCommand {

    private static final Logger LOG = Logger.getLogger(DefaultBrainTreeGraphQLExchangeLegacyIdCommand.class);

    private static final String DEFINITION_FILE_NAME = "idFromLegacyId";

    @Override
    public String perform(BrainTreeExchangeLegacyIdRequest request) {
        try {
            Map<String, Object> result = makeGraphQlCall(DEFINITION_FILE_NAME, createVariablesMap(request));
            Map<String, Object> data = (Map<String, Object>) result.get(RESULT_DATA);
            List<Map<String, Object>> errors = (List<Map<String, Object>>) result.get(RESULT_ERRORS);

            if (errors != null) {
                String errorMessage =
                    "[BT Exchange legacy id] Error due to exchanging token. " + getFistErrorMessage(errors);
                LOG.error(errorMessage);
                throw new IllegalArgumentException(errorMessage);
            }

            return (String) data.get(ID_FROM_LEGACY_PARAMETER);
        } catch (IOException e) {
            LOG.error("[BT Exchange legacy id] can not find graphQL query definition file", e);
            throw new IllegalArgumentException(e);
        }

    }

    private Map<String, Object> createVariablesMap(BrainTreeExchangeLegacyIdRequest brainTreeExchangeLegacyIdRequest) {
        Map<String, Object> map = new HashMap<>();
        map.put(LEGACY_ID_PARAMETER, brainTreeExchangeLegacyIdRequest.getLegacyId());
        map.put(TYPE_PARAMETER, brainTreeExchangeLegacyIdRequest.getType());
        return map;
    }

}
