/*

 */
package com.braintree.email.emailServices;

import com.braintree.email.emailEvents.BraintreeLocalPaymentReversedEmailEvent;
import de.hybris.platform.core.model.order.OrderModel;
import de.hybris.platform.core.model.user.CustomerModel;
import de.hybris.platform.servicelayer.event.EventService;
import de.hybris.platform.servicelayer.event.events.AbstractEvent;
import de.hybris.platform.servicelayer.i18n.CommonI18NService;
import de.hybris.platform.site.BaseSiteService;
import de.hybris.platform.store.services.BaseStoreService;

import java.text.MessageFormat;

/**
 * This is a BraintreeLocalPaymentReversedEmailEventService class
 */
public class BraintreeLocalPaymentReversedEmailEventService {

    private EventService eventService;
    private BaseSiteService baseSiteService;
    private BaseStoreService baseStoreService;
    private CommonI18NService commonI18NService;

    /**
     * This method send a BraintreeLocalPaymentReversedEmailEvent
     * @param customerModel customer model
     * @param orderModel order model
     */
    public void sendBraintreeLocalPaymentReversedEmailEvent(final CustomerModel customerModel, final OrderModel orderModel)
    {
        getEventService().publishEvent(initializeBraintreeLocalPaymentReversedEmailEvent(
                new BraintreeLocalPaymentReversedEmailEvent(), customerModel, orderModel));
    }

    private AbstractEvent initializeBraintreeLocalPaymentReversedEmailEvent(final BraintreeLocalPaymentReversedEmailEvent event,
                                                        final CustomerModel customerModel, final OrderModel orderModel){
        event.setBaseStore(getBaseStoreService().getCurrentBaseStore());
        event.setSite(getBaseSiteService().getCurrentBaseSite());
        event.setCustomer(customerModel);
        event.setLanguage(getCommonI18NService().getCurrentLanguage());
        event.setCurrency(getCommonI18NService().getCurrentCurrency());
        event.setContent(MessageFormat
                .format("Your Order {0} was not placed successful - Automated Message - DO NOT REPLY",
                        orderModel.getCode()));
        event.setOrderModel(orderModel);

        return event;
    }

    public EventService getEventService() {
        return eventService;
    }

    public void setEventService(EventService eventService) {
        this.eventService = eventService;
    }

    public BaseSiteService getBaseSiteService() {
        return baseSiteService;
    }

    public void setBaseSiteService(BaseSiteService baseSiteService) {
        this.baseSiteService = baseSiteService;
    }

    public BaseStoreService getBaseStoreService() {
        return baseStoreService;
    }

    public void setBaseStoreService(BaseStoreService baseStoreService) {
        this.baseStoreService = baseStoreService;
    }

    public CommonI18NService getCommonI18NService() {
        return commonI18NService;
    }

    public void setCommonI18NService(CommonI18NService commonI18NService) {
        this.commonI18NService = commonI18NService;
    }
}
