package com.braintree.customfield.service.impl;

import com.braintree.constants.BraintreeConstants.PropertyConfiguration;
import com.braintree.customfield.service.BraintreeCustomFieldsService;
import de.hybris.platform.servicelayer.config.ConfigurationService;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/**
 * This class is a standard implementation of the BraintreeCustomFieldsService interface
 */
public class DefaultBraintreeCustomFieldsService implements BraintreeCustomFieldsService {

    private ConfigurationService configurationService;

    @Override
    public Map<String, String> getDefaultCustomFieldsMap() {
        final Iterator<String> customFieldsNames = configurationService.getConfiguration()
            .getKeys(PropertyConfiguration.BRAINTRE_CUSTOM_FIELD_GENERAL_KEY);
        final Map<String, String> customFields = new HashMap<>();

        while (customFieldsNames.hasNext()) {
            final String customFieldName = customFieldsNames.next();
            final String customFieldValue = configurationService.getConfiguration().getString(customFieldName);
            if (!"".equals(customFieldValue)) {
                customFields
                    .put(customFieldName.replaceFirst(PropertyConfiguration.BRAINTRE_CUSTOM_FIELD_GENERAL_KEY + ".", ""),
                        customFieldValue);
            }
        }

        return customFields;
    }

    public ConfigurationService getConfigurationService() {
        return configurationService;
    }

    public void setConfigurationService(final ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

}
