/*
 * [y] hybris Platform
 *
 * Copyright (c) 2000-2013 hybris AG
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of hybris
 * ("Confidential Information"). You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms of the
 * license agreement you entered into with hybris.
 *
 *
 */
package com.braintree.constants;

/**
 * Global class for all Braintree constants. You can add global constants for your extension into this class.
 */
public final class BraintreeConstants extends GeneratedBraintreeConstants {

    public interface InstrumentType {

        String PAYPAL_PAYMENT_INSTRUMENT_TYPE = "paypal_account";
        String VENMO_PAYMENT_INSTRUMENT_TYPE = "venmo_account";
        String US_BANK_ACCOUNT_PAYMENT_INSTRUMENT_TYPE = "us_bank_account";
        String CREDIT_CARD_PAYMENT_INSTRUMENT_TYPE = "credit_card";
        String ANDROID_PAY_CARD_PAYMENT_INSTRUMENT_TYPE = "android_pay_card";
        String VISA_CHECKOUT_CARD_PAYMENT_INSTRUMENT_TYPE = "visa_checkout_card";
        String LOCAL_PAYMENT_INSTRUMENT_TYPE = "local_payment";
        String APPLE_PAY_PAYMENT_INSTRUMENT_TYPE = "apple_pay_card";
    }

    public interface PayPalIntent {

        String PAYPAL_INTENT_SALE = "sale";
        String PAYPAL_INTENT_AUTHORIZE = "authorize";
        String PAYPAL_INTENT_ORDER = "order";
    }

    public interface PropertyConfiguration {
        String BRAINTREE_PRIVATE_KEY = "braintree.private_key";
        String BRAINTREE_PUBLIC_KEY = "braintree.public_key";
        String BRAINTREE_MERCHANT_ID = "braintree.merchant_id";

        String BRAINTREE_SUBMIT_FOR_SETTLEMENT = "braintree.submit.for.settlement";
        String BRAINTREE_ADVANCED_FRAUD_TOOLS_ENABLED = "braintree.advanced.fraud.tools.enabled";

        String BRAINTREE_3D_SECURE = "braintree.3d.secure";
        String BRAINTREE_3D_SECURE_FALLBACK = "braintree.3d.secure.fallback";
        String IS_SKIP_3D_SECURE_LIABILITY_RESULT = "braintree.skip.3dsecure.liability.result";
        String VERIFY_CARD = "braintree.verify.card";
        String BRAINTREE_3D_SECURE_VERIFICATION_MY_ACCOUNT = "braintree.3d.secure.myaccount";
        String PAYPAL_EXPRESS_ENABLED = "braintree.express.paypal.enabled";
        String PAYPAL_STANDARD_ENABLED = "braintree.standard.paypal.enabled";
        String HOSTED_FIELDS_ENABLED = "braintree.hosted.fields.enabled";
        String BRAINTREE_APPLE_PAY_ENABLE = "braintree.applePay.enable";

        String BRAINTREE_APPLE_PAY_ON_EXPRESS_CHECKOUT_ENABLE = "braintree.applePayOnExpressCheckout.enable";
        String BRAINTREE_VENMO_ENABLE = "braintree.venmo.enable";
        String BRAINTREE_US_BANK_ACCOUNT_ENABLE = "braintree.ACH.enabled";
        String BRAINTREE_US_BANK_ACCOUNT_MERCHANT_NAME = "ach.merchantname.legal.text";
        String BRAINTREE_SRC_ENABLE = "braintree.src.enable";
        String BRAINTREE_GRAPHQL_ENABLE = "braintree.graphql.enable";
        String BRAINTREE_DROPIN_ENABLE = "braintree.dropin.enable";
        String BRAINTREE_CREDIT_CARD_EXPIRE_BETWEEN = "braintree.credit.card.expire.between";
        String BRAINTREE_CREDIT_CARD_EXPIRE_ON_ADDING_VALIDATION_ENABLED = "braintree.credit.card.expire.on.adding.validation";
        String BRAINTREE_GOOGLE_PAY_ENABLE = "braintree.googlePay.enable";
        String BRAINTREE_GOOGLE_PAY_ON_EXPRESS_CHECKOUT_ENABLE = "braintree.googlePayOnExpressCheckout.enable";
        String BRAINTREE_LOCAL_PAYMENTS_ENABLE = "braintree.local.payments.enable";

        String PAYPAL_DISABLE_FUNDING = "braintree.disable.funding";
        String BILLING_AGREEMENT_DESCRIPTION_KEY = "braintree.billing.agreement.text";
        String BRAINTREE_PAYLATER_FOR_NON_US_COUNTRIES = "braintree.paylater.for.non.us.countries";
        String BRAINTREE_CREDIT_ENABLE = "braintree.credit.enable";
        String BRAINTREE_CHANGE_PAYMENT_METHOD_ENABLED = "braintree.change.payment.method.enabled";

        String BRAINTREE_GOOGLE_PAY_MERCHANT_ID = "braintree.googlePay.merchant_id";
        String BRAINTREE_GOOGLE_PAY_COUNTRY_CODE = "braintree.googlepay.seller.country.code";


        String STORE_IN_VAULT = "braintree.store.in.vault";
        String BRAINTREE_PAYPAL_INTENT = "braintree.paypal.intent";
        String SINGLE_USE_PARAMETER = "braintree.single.use";
        String LOG_ALL_ENABLE = "braintree.log.all.enable";
        String BRAINTREE_ENVIRONMENT = "braintree.environment.type";
        String BRAINTREE_CREDIT_CARD_STATEMENT_NAME = "braintree.credit.card.statement.name";
        String BRAINTREE_CHANNEL_NAME = "braintree.channel";
        String BRAINTREE_KEY = "braintree.channel.source.key";
        String BRAINTREE_ACCEPTED_PAYMENT_METHODS = "braintree.accepted.payment.methods";
        String BRAINTREE_ACCEPTED_CREDIT_CARD_PAYMENT_METHODS = "braintree.accepted.credit.card.payment.methods";
        String BRAINTREE_IMAGES_PREFIX = "braintree.image.";
        String BRAINTREE_MERCHANT_ACCOUNT_PREFIX = "braintree.merchant.account.";
        String MULTICAPTURE_ENABLED = "braintree.multicapture";
        String GENERAL_VALIDATION_ERROR_MESSAGE = "braintree.verify.card.general.error.msg";
        String FAILED_VERIFICATION_ERROR_MESSAGE = "Payment method failed verification.";
        String DO_NOT_HONOR = "Do Not Honor";
        String ORDER_PROCESS_RESTART_NODE = "braintree.order.process.restart.node";
        String BRAINTREE_AUTHENTICATION_TOKEN = "braintree.authentication.token";
        String BRAINTREE_ECVZ_ACEESS_TOKEN = "braintree.ecvz.access.token";
        String BRAINTRE_CUSTOM_FIELD_GENERAL_KEY = "braintree.custom.field";
        String BRAINTREE_USER_ACTION = "braintree.user.action";
        String BRAINTREE_LOCALE = "braintree.locale";
        String HYBRIS_BUILD_API_VERSION = "build.version.api";
        String B2C_FLOW = "braintree.b2c";
        String BRAINTREE_SRC_SDK_URL = "braintree.src.sdk.url";
        String BRAINTREE_SRC_IMG_URL = "braintree.src.img.url";
        String BRAINTREE_VENMO_PROFILE_ID = "braintree.venmo.profile.id";
        String TRANSACTION_ID_INVALID = "message.braintree.order.refund.partial.transaction.id.invalid";
        String MERCHANT_CODE_IS_MISSING = "message.braintree.order.refund.partial.merchant.code.is.missing";
        String TRANSACTION_NOT_REFUNDABLE = "message.braintree.order.refund.partial.transaction.not.refundable";
        String ALL_TRANSACTIONS_ALREADY_REFUNDED = "message.braintree.order.refund.partial.transactions.already.refunded";
        String EXCEEDED_CAPTURE_AMOUNT = "message.braintree.order.capture.exceeded.capture.amount";
        String PROPERTY_LEVEL2_LEVEL3 = "braintree.enable.level2.level3.data";
        String CURRENCY_MERCHANT_ACCOUNT_ID = "braintree.currency.merchant.account.id";
        String B2C_ENDPOINT_URL_PROPERTY = "website.electronics.https";
        String BRAINTREE_SEARCH_LIMIT = "braintree.search.limit";
        String PAYPAL_CONNECT_ADD_PAYMENT_METHOD_FLOW = "paypal.connect.addPaymentMethodFlow";
        String PAYPAL_LIPP_LINK_USERS_ACCOUNT = "paypal.lipp.link.users.account";
        String BRAINTREE_VERIFY_FLOW = "braintree.reverify.flow";
        String BRAINTREE_RESTRICTION_PM_REMOVAL_ENABLED = "braintree.restriction.pm.removal.enable";
    }


    public static final String EXTENSIONNAME = "braintree";
    public static final String TRANSACTION_SEARCH_DATE_FORMAT = "MM/dd/yy h:mm a";
    public static final String PAYPAL_PAYMENT_TYPE_NAME = "PayPal Account";
    public static final String CREDIT_CARD_PAYMENT_TYPE = "Credit Card";
    public static final String LOG_PACKAGE_PATH = "com.braintree";
    public static final String BRAINTREE_PROVIDER_NAME = "BrainTree";
    public static final String CARD_NUMBER_MASK = "**************%s";
    public static final String ENVIRONMENT_SANDBOX = "sandbox";
    public static final String ENVIRONMENT_PRODUCTION = "production";
    public static final String BRAINTREE_3D_SECURE_ENVIRONMENT_PSD2 = "psd2";
    public static final String BRAINTREE_3D_SECURE_ENVIRONMENT_UNAVAILABLE = "unavailable";
    public static final String BRAINTREE_ACCEPTED_PAYMENT_METHODS_DELIMETER = ";";
    public static final String CONFIGURATION_PROPERTY_DELIMETER = ".";
    public static final String ORDER_PROCESS_NAME = "order-process";
    public static final String DEFAULT_ORDER_PROCESS_RESTART_NODE = "splitOrder";
    public static final String FAKE_REQUEST_ID = "FAKE";
    public static final String GUEST_USER_TYPE = "GUEST";

    public static final String PAYPAL_FUNDING_SOURCE = "paypal";
    public static final String CARD_FUNDING_SOURCE = "card";

    public static final String BRAINTREE_SUCCESS = "SUCCESS";
    public static final String BRAINTREE_NOT_SUCCESS = "NOT SUCCESS";
    public static final String BRAINTREE_REJECT = "REJECT";
    public static final String BRAINTREE_SUCCESS_MESSAGE = "Transaction was successful";
    public static final String BRAINTREE_PARSE_TO_JSON_EXCEPTION = "Exception during parsing to JSON";
    public static final String BRAINTREE_INTERACTION_TYPE_VOID = "VOID";
    public static final String BRAINTREE_INTERACTION_TYPE_VOID_INTENT_ORDER = "VOID_ORDER";
    public static final String BRAINTREE_INTERACTION_TYPE_VOID_INTENT_ORDER_MESSAGE = "Deleting payment method from braintree";
    public static final String BRAINTREE_DISABLE_FUNDING_ON_MY_ACCOUNT = "card,paylater";
    public static final String COMMA_SEPARATOR = ",";
    public static final String CURRENCY = "currency";
    public static final String USD = "USD";
    public static final String NETWORK_CHECK = "NETWORK_CHECK";


    public static final String BRAINTREE_PAGE_TYPE_OTHER = "OTHER";

    public static final String BRAINTREE_TRY_DELETE_PAYMENT_DETAILS_WITH_NOT_CAPTURED_ORDER = "Try delete payment details with not captured order";

    // Braintree GraphQL Command Parameters

    public static final String RESULT_DATA = "data";
    public static final String RESULT_ERRORS = "errors";
    public static final String LEGACY_ID_PARAMETER = "legacyId";
    public static final String TYPE_PARAMETER = "type";
    public static final String TYPE_TRANSACTION_PARAMETER = "TRANSACTION";
    public static final String TYPE_PAYMENT_METHOD_PARAMETER = "PAYMENT_METHOD";
    public static final String TYPE_CUSTOMER_PARAMETER = "CUSTOMER";
    public static final String ID_FROM_LEGACY_PARAMETER = "idFromLegacyId";
    public static final String INPUT_PARAMETER = "input";
    public static final String AFTER_PARAMETER = "after";
    public static final String ID_PARAMETER = "id";
    public static final String TRANSACTION_ID_PARAMETER = "transactionId";

    public static final String PAYPAL_ACCOUNT_DETAILS = "PayPalAccountDetails";
    public static final String US_BANK_ACCOUNT_DETAIL = "UsBankAccountDetails";
    public static final String US_BANK_ACCOUNT = "UsBankAccount";
    public static final String PAYPAL_TRANSACTION_DETAILS = "PayPalTransactionDetails";
    public static final String CREDIT_CARD_DETAILS = "CreditCardDetails";
    public static final String CREDIT_CARD_TRANSACTION_DETAILS = "CreditCardTransactionDetails";
    public static final String VENMO_ACCOUNT_DETAILS = "VenmoAccountDetails";
    public static final String LOCAL_PAYMENT_DETAILS = "LocalPaymentDetails";
    public static final String GOOGLE_PAY_ORIGIN_TYPE = "GOOGLE_PAY";
    public static final String VISA_CHECKOUT_ORIGIN_TYPE = "VISA_CHECKOUT";
    public static final String APPLE_PAY_ORIGIN_TYPE = "APPLE_PAY";

    public static final String GRAPHQL_AUTHORIZED_EVENT_TYPE = "AuthorizedEvent";
    public static final String GRAPHQL_SETTLED_EVENT_TYPE = "SettledEvent";

    public static final String VERIFICATION_STATUS_FAILED = "FAILED";
    public static final String PAYPAL_CONNECT_SCRIPT = "paypal.connect.script";
    public static final String PAYPAL_CONNECT_SCOPES = "paypal.connect.scopes";
    public static final String PAYPAL_CONNECT_RESPONSE_TYPE = "paypal.connect.responseType";
    public static final String PAYPAL_CONNECT_RETURN_URL = "paypal.connect.returnUrl";
    public static final String PAYPAL_CONNECT_CHECKOUT_RETURN_URL = "paypal.connect.checkout.returnUrl";
    public static final String CLIENT_ID = "paypal.client.id";
    public static final String SECRET_KEY = "paypal.secret.key";
    public static final String PAYPAL_API_URL = "paypal.api.url";
    public static final String AUTHORIZATION_HEADER = "Authorization";
    public static final String CVV_FAILED_VERIFICATION_ERROR_MESSAGE = "Payment method failed cvv verification.";

    private BraintreeConstants() {
        //empty to avoid instantiating this constant class
    }

}
