package com.braintree.commands.impl;

import com.braintree.command.result.BrainTreeRefundTransactionResult;
import com.braintree.command.result.BrainTreeTransactionResult;
import com.braintree.commands.BrainTreeFindTransactionByIdCommand;
import com.braintreegateway.Transaction;
import com.google.gson.Gson;
import de.hybris.platform.servicelayer.dto.converter.Converter;
import org.apache.log4j.Logger;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

public class DefaultBrainTreeFindTransactionByIdCommand extends AbstractCommand
        implements BrainTreeFindTransactionByIdCommand {

    private static final Logger LOG = Logger.getLogger(DefaultBrainTreeFindTransactionByIdCommand.class);

    @Resource
    private Converter<Transaction, BrainTreeRefundTransactionResult> transactionToBraintreeRefundResultConverter;

    @Resource
    private Converter<Transaction, BrainTreeTransactionResult> transactionToBraintreeTransactionResultConverter;

    @Override
    public BrainTreeTransactionResult perform(String transactionId) {
        Transaction transaction = getBraintreeGateway().transaction().find(transactionId);
        LOG.info("Transaction: " + new Gson().toJson(transaction));

        return translateResponse(transaction);
    }

    private BrainTreeTransactionResult translateResponse(Transaction transaction) {
        BrainTreeTransactionResult transactionResult = transactionToBraintreeTransactionResultConverter.convert(transaction);
        List<BrainTreeRefundTransactionResult> refunds = new ArrayList<>();
        transaction.getRefundIds().forEach(id -> {
            Transaction refundTransaction = getBraintreeGateway().transaction().find(id);
            refunds.add(transactionToBraintreeRefundResultConverter.convert(refundTransaction));
        });
        transactionResult.setRefunds(refunds);

        LOG.info("Found and translated BrainTreeTransactionResult = " + new Gson().toJson(transactionResult));
        return transactionResult;
    }

}