/**
 *
 */
package com.braintree.commands.impl;

import com.braintree.command.request.BrainTreeAuthorizationRequest;
import com.braintree.command.result.BrainTreeAuthorizationResult;
import com.braintree.util.BrainTreeUtils;
import de.hybris.platform.payment.commands.AuthorizationCommand;
import de.hybris.platform.payment.commands.request.AuthorizationRequest;
import de.hybris.platform.payment.commands.result.AuthorizationResult;
import de.hybris.platform.servicelayer.config.ConfigurationService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;

/**
 * This abstract class is for authorization in subordinate classes.
 */
public abstract class AbstractAuthorizationCommand extends AbstractCommand<AuthorizationRequest, AuthorizationResult>
    implements AuthorizationCommand {

    protected static final String AUTHORIZATION_TRANSACTION = "[AUTHORIZATION TRANSACTION] ";

    protected ConfigurationService configurationService;

    protected boolean shouldGetPaymentMethodTokenFromBraintree(BrainTreeAuthorizationResult authorizationResult,
        AuthorizationRequest authorizationRequest) {
        if (authorizationRequest instanceof BrainTreeAuthorizationRequest) {
            final BrainTreeAuthorizationRequest brainTreeAuthorizationRequest = (BrainTreeAuthorizationRequest) authorizationRequest;
            final boolean isAlreadyVaulted = brainTreeAuthorizationRequest.getUsePaymentMethodToken();
            final boolean storeInVaultForCard = getBrainTreeConfigService()
                    .isStoreInVaultForCardVaulting(brainTreeAuthorizationRequest.getCustomerId());
            final boolean isPayPalPayment = BrainTreeUtils
                .isPayPalPayment(brainTreeAuthorizationRequest.getPaymentType());
            final boolean isNotAlreadyVaultedAndIsPayPalPayment = !isAlreadyVaulted && isPayPalPayment;
            return storeInVaultForCard && getBrainTreeConfigService()
                .isChangePaymentMethodButtonEnabled() && isNotAlreadyVaultedAndIsPayPalPayment
                && authorizationResult.getPaymentDetails().getPaymentMethodToken() == null;
        }
        return false;
    }

    protected boolean isLevel2Applicable(final BrainTreeAuthorizationRequest request) {
        final boolean isOrderNumberValid = StringUtils.isAsciiPrintable(request.getPurchaseOrderNumber())
            && (request.getPurchaseOrderNumber().length() <= 12);
        final boolean isTaxAmountValid = request.getTaxAmountAuthorize().compareTo(0d) >= 0;

        return isOrderNumberValid && isTaxAmountValid;
    }

    protected static BigDecimal roundNumberToTwoDecimalPlaces(final Double number) {
        return BigDecimal.valueOf(number).setScale(2, RoundingMode.HALF_UP);
    }

    protected boolean isThreeDSRequired(BrainTreeAuthorizationRequest brainTreeAuthorizationRequest) {
        return BooleanUtils.isTrue(brainTreeAuthorizationRequest.getThreeDSecureConfiguration())
            && (!(brainTreeAuthorizationRequest.getUsePaymentMethodToken()))
            && getBrainTreeConfigService().is3dSecureConfiguration();
    }

    public ConfigurationService getConfigurationService() {
        return configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }
}
