/**
 *
 */
package com.braintree.commands.factory;

import com.braintree.configuration.service.BrainTreeConfigService;
import de.hybris.platform.payment.commands.Command;
import de.hybris.platform.payment.commands.factory.CommandFactory;
import de.hybris.platform.payment.commands.factory.CommandNotSupportedException;
import java.util.Map;

public class DefaultBrainTreeCommandFactory implements CommandFactory {

    private Map<Class<Command>, Command> restCommands;
    private Map<Class<Command>, Command> graphQLCommands;
    private BrainTreeConfigService brainTreeConfigService;
    private String paymentProvider;

    @Override
    public <T extends Command> T createCommand(Class<T> commandInterface) throws CommandNotSupportedException {
        T command;
        if (brainTreeConfigService.isBrainTreeGraphQLEnabled()) {
            command = (T) graphQLCommands.get(commandInterface);
        } else {
            command = (T) restCommands.get(commandInterface);
        }

        if (command == null) {
            throw new CommandNotSupportedException("Command not implemented: " + commandInterface.getCanonicalName());
        }

        return command;
    }

    @Override
    public String getPaymentProvider() {
        return paymentProvider;
    }

    public void setPaymentProvider(String paymentProvider) {
        this.paymentProvider = paymentProvider;
    }

    public void setBrainTreeConfigService(BrainTreeConfigService brainTreeConfigService) {
        this.brainTreeConfigService = brainTreeConfigService;
    }

    public void setRestCommands(
        Map<Class<Command>, Command> restCommands) {
        this.restCommands = restCommands;
    }

    public void setGraphQLCommands(
        Map<Class<Command>, Command> graphQLCommands) {
        this.graphQLCommands = graphQLCommands;
    }
}
